/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ItemDocumentImpl.class, name="item"), @JsonSubTypes.Type(value=PropertyDocumentImpl.class, name="property")})
public abstract class TermedStatementDocumentImpl
extends StatementDocumentImpl
implements TermedStatementDocument {
    protected final Map<String, List<MonolingualTextValue>> aliases;
    protected final Map<String, MonolingualTextValue> labels;
    protected final Map<String, MonolingualTextValue> descriptions;

    public TermedStatementDocumentImpl(EntityIdValue id, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> claims, long revisionId) {
        super(id, claims, revisionId);
        this.labels = labels != null ? TermedStatementDocumentImpl.constructTermMap(labels) : Collections.emptyMap();
        this.descriptions = descriptions != null ? TermedStatementDocumentImpl.constructTermMap(descriptions) : Collections.emptyMap();
        this.aliases = aliases != null ? TermedStatementDocumentImpl.constructTermListMap(aliases) : Collections.emptyMap();
    }

    TermedStatementDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="labels") Map<String, MonolingualTextValue> labels, @JsonProperty(value="descriptions") Map<String, MonolingualTextValue> descriptions, @JsonProperty(value="aliases") Map<String, List<MonolingualTextValue>> aliases, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, claims, revisionId, siteIri);
        this.labels = labels != null ? labels : Collections.emptyMap();
        this.descriptions = descriptions != null ? descriptions : Collections.emptyMap();
        this.aliases = aliases != null ? aliases : Collections.emptyMap();
    }

    protected TermedStatementDocumentImpl(EntityIdValue subject, Map<String, MonolingualTextValue> labels, Map<String, MonolingualTextValue> descriptions, Map<String, List<MonolingualTextValue>> aliases, Map<String, List<Statement>> claims, long revisionId) {
        super(subject, claims, revisionId);
        this.labels = labels;
        this.descriptions = descriptions;
        this.aliases = aliases;
    }

    @Override
    @JsonProperty(value="aliases")
    public Map<String, List<MonolingualTextValue>> getAliases() {
        HashMap<String, List<MonolingualTextValue>> returnMap = new HashMap<String, List<MonolingualTextValue>>();
        for (Map.Entry<String, List<MonolingualTextValue>> entry : this.aliases.entrySet()) {
            returnMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(returnMap);
    }

    @Override
    @JsonProperty(value="descriptions")
    public Map<String, MonolingualTextValue> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    @Override
    @JsonProperty(value="labels")
    public Map<String, MonolingualTextValue> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    @Override
    @JsonIgnore
    public String getSiteIri() {
        return this.siteIri;
    }

    protected static Map<String, MonolingualTextValue> constructTermMap(List<MonolingualTextValue> terms) {
        HashMap<String, MonolingualTextValue> map = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue term : terms) {
            String language = term.getLanguageCode();
            if (map.containsKey(language)) {
                throw new IllegalArgumentException("Multiple terms provided for the same language.");
            }
            map.put(language, TermedStatementDocumentImpl.toTerm(term));
        }
        return map;
    }

    private static Map<String, List<MonolingualTextValue>> constructTermListMap(List<MonolingualTextValue> terms) {
        HashMap<String, List<MonolingualTextValue>> map = new HashMap<String, List<MonolingualTextValue>>();
        for (MonolingualTextValue term : terms) {
            String language = term.getLanguageCode();
            List aliases = map.computeIfAbsent(language, l -> new ArrayList());
            aliases.add(TermedStatementDocumentImpl.toTerm(term));
        }
        return map;
    }

    private static MonolingualTextValue toTerm(MonolingualTextValue term) {
        return term instanceof TermImpl ? term : new TermImpl(term.getLanguageCode(), term.getText());
    }

    @Override
    public abstract TermedStatementDocument withRevisionId(long var1);

    static class AliasesDeserializer
    extends JsonDeserializer<Map<String, List<MonolingualTextValue>>> {
        AliasesDeserializer() {
        }

        public Map<String, List<MonolingualTextValue>> deserialize(JsonParser jp, DeserializationContext ctxt) throws JsonMappingException {
            HashMap<String, List<MonolingualTextValue>> contents = new HashMap<String, List<MonolingualTextValue>>();
            try {
                JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
                if (!node.isArray()) {
                    Iterator nodeIterator = node.fields();
                    while (nodeIterator.hasNext()) {
                        ArrayList<TermImpl> mltvList = new ArrayList<TermImpl>();
                        Map.Entry currentNode = (Map.Entry)nodeIterator.next();
                        for (JsonNode mltvEntry : (JsonNode)currentNode.getValue()) {
                            String language = mltvEntry.get("language").asText();
                            String value = mltvEntry.get("value").asText();
                            mltvList.add(new TermImpl(language, value));
                        }
                        contents.put((String)currentNode.getKey(), mltvList);
                    }
                }
            }
            catch (Exception e) {
                throw new JsonMappingException((Closeable)jp, "Unexpected alias list serialization", (Throwable)e);
            }
            return contents;
        }
    }
}

