/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.implementation.DatatypeIdImpl;
import org.wikidata.wdtk.datamodel.implementation.FormDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.FormIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.GlobeCoordinatesValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.MediaInfoDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.MediaInfoIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.MonolingualTextValueImpl;
import org.wikidata.wdtk.datamodel.implementation.NoValueSnakImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.QuantityValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ReferenceImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SiteLinkImpl;
import org.wikidata.wdtk.datamodel.implementation.SnakGroupImpl;
import org.wikidata.wdtk.datamodel.implementation.SomeValueSnakImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementGroupImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.StringValueImpl;
import org.wikidata.wdtk.datamodel.implementation.TimeValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueSnakImpl;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class DataObjectFactoryImpl
implements DataObjectFactory {
    @Override
    public ItemIdValue getItemIdValue(String id, String siteIri) {
        return new ItemIdValueImpl(id, siteIri);
    }

    @Override
    public PropertyIdValue getPropertyIdValue(String id, String siteIri) {
        return new PropertyIdValueImpl(id, siteIri);
    }

    @Override
    public LexemeIdValue getLexemeIdValue(String id, String siteIri) {
        return new LexemeIdValueImpl(id, siteIri);
    }

    @Override
    public FormIdValue getFormIdValue(String id, String siteIri) {
        return new FormIdValueImpl(id, siteIri);
    }

    @Override
    public SenseIdValue getSenseIdValue(String id, String siteIri) {
        return new SenseIdValueImpl(id, siteIri);
    }

    @Override
    public MediaInfoIdValue getMediaInfoIdValue(String id, String siteIri) {
        return new MediaInfoIdValueImpl(id, siteIri);
    }

    @Override
    public DatatypeIdValue getDatatypeIdValue(String id) {
        return new DatatypeIdImpl(id);
    }

    @Override
    public TimeValue getTimeValue(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        return new TimeValueImpl(year, month, day, hour, minute, second, precision, beforeTolerance, afterTolerance, timezoneOffset, calendarModel);
    }

    @Override
    public GlobeCoordinatesValue getGlobeCoordinatesValue(double latitude, double longitude, double precision, String globeIri) {
        if (precision <= 0.0) {
            throw new IllegalArgumentException("Coordinates precision must be non-zero positive. Given value: " + precision);
        }
        return new GlobeCoordinatesValueImpl(latitude, longitude, precision, globeIri);
    }

    @Override
    public StringValue getStringValue(String string) {
        return new StringValueImpl(string);
    }

    @Override
    public MonolingualTextValue getMonolingualTextValue(String text, String languageCode) {
        return new MonolingualTextValueImpl(text, languageCode);
    }

    @Override
    public QuantityValue getQuantityValue(BigDecimal numericValue) {
        return this.getQuantityValue(numericValue, null, null, "1");
    }

    @Override
    public QuantityValue getQuantityValue(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound) {
        return this.getQuantityValue(numericValue, lowerBound, upperBound, "1");
    }

    @Override
    public QuantityValue getQuantityValue(BigDecimal numericValue, String unit) {
        return this.getQuantityValue(numericValue, null, null, unit);
    }

    @Override
    public QuantityValue getQuantityValue(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound, String unit) {
        return new QuantityValueImpl(numericValue, lowerBound, upperBound, unit);
    }

    @Override
    public ValueSnak getValueSnak(PropertyIdValue propertyId, Value value) {
        return new ValueSnakImpl(propertyId, value);
    }

    @Override
    public SomeValueSnak getSomeValueSnak(PropertyIdValue propertyId) {
        return new SomeValueSnakImpl(propertyId.getId(), propertyId.getSiteIri());
    }

    @Override
    public NoValueSnak getNoValueSnak(PropertyIdValue propertyId) {
        return new NoValueSnakImpl(propertyId.getId(), propertyId.getSiteIri());
    }

    @Override
    public SnakGroup getSnakGroup(List<? extends Snak> snaks) {
        return new SnakGroupImpl(new ArrayList<Snak>(snaks));
    }

    @Override
    public Claim getClaim(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        return this.getStatement(subject, mainSnak, qualifiers, Collections.emptyList(), StatementRank.NORMAL, "empty id 12345").getClaim();
    }

    @Override
    public Reference getReference(List<SnakGroup> snakGroups) {
        return new ReferenceImpl(snakGroups);
    }

    @Override
    public Statement getStatement(Claim claim, List<Reference> references, StatementRank rank, String statementId) {
        return this.getStatement(claim.getSubject(), claim.getMainSnak(), claim.getQualifiers(), references, rank, statementId);
    }

    @Override
    public Statement getStatement(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers, List<Reference> references, StatementRank rank, String statementId) {
        return new StatementImpl(statementId, rank, mainSnak, qualifiers, references, subject);
    }

    @Override
    public StatementGroup getStatementGroup(List<Statement> statements) {
        return new StatementGroupImpl(statements);
    }

    @Override
    public SiteLink getSiteLink(String title, String siteKey, List<ItemIdValue> badges) {
        return new SiteLinkImpl(title, siteKey, badges);
    }

    @Override
    public PropertyDocument getPropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, DatatypeIdValue datatypeId, long revisionId) {
        return new PropertyDocumentImpl(propertyId, labels, descriptions, aliases, statementGroups, datatypeId, revisionId);
    }

    @Override
    public ItemDocument getItemDocument(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks, long revisionId) {
        return new ItemDocumentImpl(itemIdValue, labels, descriptions, aliases, statementGroups, new ArrayList<SiteLink>(siteLinks.values()), revisionId);
    }

    @Override
    public LexemeDocument getLexemeDocument(LexemeIdValue lexemeIdValue, ItemIdValue lexicalCategory, ItemIdValue language, List<MonolingualTextValue> lemmas, List<StatementGroup> statementGroups, List<FormDocument> forms, List<SenseDocument> senses, long revisionId) {
        return new LexemeDocumentImpl(lexemeIdValue, lexicalCategory, language, lemmas, statementGroups, forms, senses, revisionId);
    }

    @Override
    public FormDocument getFormDocument(FormIdValue formIdValue, List<MonolingualTextValue> representations, List<ItemIdValue> grammaticalFeatures, List<StatementGroup> statementGroups, long revisionId) {
        return new FormDocumentImpl(formIdValue, representations, grammaticalFeatures, statementGroups, revisionId);
    }

    @Override
    public SenseDocument getSenseDocument(SenseIdValue senseIdValue, List<MonolingualTextValue> glosses, List<StatementGroup> statementGroups, long revisionId) {
        return new SenseDocumentImpl(senseIdValue, glosses, statementGroups, revisionId);
    }

    @Override
    public MediaInfoDocument getMediaInfoDocument(MediaInfoIdValue mediaInfoIdValue, List<MonolingualTextValue> labels, List<StatementGroup> statementGroups, long revisionId) {
        return new MediaInfoDocumentImpl(mediaInfoIdValue, labels, statementGroups, revisionId);
    }
}

