/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;

public class DatatypeIdImpl
implements DatatypeIdValue {
    public static final String JSON_DT_ITEM = "wikibase-item";
    public static final String JSON_DT_PROPERTY = "wikibase-property";
    public static final String JSON_DT_GLOBE_COORDINATES = "globe-coordinate";
    public static final String JSON_DT_URL = "url";
    public static final String JSON_DT_COMMONS_MEDIA = "commonsMedia";
    public static final String JSON_DT_TIME = "time";
    public static final String JSON_DT_QUANTITY = "quantity";
    public static final String JSON_DT_STRING = "string";
    public static final String JSON_DT_MONOLINGUAL_TEXT = "monolingualtext";
    public static final String JSON_DT_EXTERNAL_ID = "external-id";
    public static final String JSON_DT_MATH = "math";
    public static final String JSON_DT_GEO_SHAPE = "geo-shape";
    private static final Pattern JSON_DATATYPE_PATTERN = Pattern.compile("^[a-z\\-]+$");
    private static final Pattern DATATYPE_ID_PATTERN = Pattern.compile("^http://wikiba\\.se/ontology#([a-zA-Z]+)$");
    private final String iri;

    public static String getDatatypeIriFromJsonDatatype(String jsonDatatype) {
        switch (jsonDatatype) {
            case "wikibase-item": {
                return "http://wikiba.se/ontology#WikibaseItem";
            }
            case "wikibase-property": {
                return "http://wikiba.se/ontology#WikibaseProperty";
            }
            case "globe-coordinate": {
                return "http://wikiba.se/ontology#GlobeCoordinate";
            }
            case "url": {
                return "http://wikiba.se/ontology#Url";
            }
            case "commonsMedia": {
                return "http://wikiba.se/ontology#CommonsMedia";
            }
            case "time": {
                return "http://wikiba.se/ontology#Time";
            }
            case "quantity": {
                return "http://wikiba.se/ontology#Quantity";
            }
            case "string": {
                return "http://wikiba.se/ontology#String";
            }
            case "monolingualtext": {
                return "http://wikiba.se/ontology#Monolingualtext";
            }
        }
        if (!JSON_DATATYPE_PATTERN.matcher(jsonDatatype).matches()) {
            throw new IllegalArgumentException("Invalid JSON datatype \"" + jsonDatatype + "\"");
        }
        Object[] parts = jsonDatatype.split("-");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.capitalize((String)parts[i]);
        }
        return "http://wikiba.se/ontology#" + StringUtils.join((Object[])parts);
    }

    public static String getJsonDatatypeFromDatatypeIri(String datatypeIri) {
        switch (datatypeIri) {
            case "http://wikiba.se/ontology#WikibaseItem": {
                return JSON_DT_ITEM;
            }
            case "http://wikiba.se/ontology#GlobeCoordinate": {
                return JSON_DT_GLOBE_COORDINATES;
            }
            case "http://wikiba.se/ontology#Url": {
                return JSON_DT_URL;
            }
            case "http://wikiba.se/ontology#CommonsMedia": {
                return JSON_DT_COMMONS_MEDIA;
            }
            case "http://wikiba.se/ontology#Time": {
                return JSON_DT_TIME;
            }
            case "http://wikiba.se/ontology#Quantity": {
                return JSON_DT_QUANTITY;
            }
            case "http://wikiba.se/ontology#String": {
                return JSON_DT_STRING;
            }
            case "http://wikiba.se/ontology#Monolingualtext": {
                return JSON_DT_MONOLINGUAL_TEXT;
            }
            case "http://wikiba.se/ontology#WikibaseProperty": {
                return JSON_DT_PROPERTY;
            }
        }
        Matcher matcher = DATATYPE_ID_PATTERN.matcher(datatypeIri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unknown datatype: " + datatypeIri);
        }
        StringBuilder jsonDatatypeBuilder = new StringBuilder();
        for (char ch : StringUtils.uncapitalize((String)matcher.group(1)).toCharArray()) {
            if (Character.isUpperCase(ch)) {
                jsonDatatypeBuilder.append('-').append(Character.toLowerCase(ch));
                continue;
            }
            jsonDatatypeBuilder.append(ch);
        }
        return jsonDatatypeBuilder.toString();
    }

    public DatatypeIdImpl(DatatypeIdValue other) {
        this.iri = other.getIri();
    }

    public DatatypeIdImpl(String iri) throws IllegalArgumentException {
        Validate.notNull((Object)iri, (String)"An IRI must be provided to create a DatatypeIdValue", (Object[])new Object[0]);
        this.iri = iri;
    }

    public String getJsonString() {
        return DatatypeIdImpl.getJsonDatatypeFromDatatypeIri(this.iri);
    }

    @Override
    public String getIri() {
        return this.iri;
    }

    public String toString() {
        return ToString.toString(this);
    }

    public boolean equals(Object o) {
        return Equality.equalsDatatypeIdValue(this, o);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }
}

