/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
public class QuantityValueImpl
extends ValueImpl
implements QuantityValue {
    private final JacksonInnerQuantity value;

    public QuantityValueImpl(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound, String unit) {
        super("quantity");
        this.value = new JacksonInnerQuantity(numericValue, lowerBound, upperBound, unit);
    }

    @JsonCreator
    QuantityValueImpl(@JsonProperty(value="value") JacksonInnerQuantity value) {
        super("quantity");
        this.value = value;
    }

    public JacksonInnerQuantity getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public BigDecimal getNumericValue() {
        return this.value.getAmount();
    }

    @Override
    @JsonIgnore
    public BigDecimal getLowerBound() {
        return this.value.getLowerBound();
    }

    @Override
    @JsonIgnore
    public BigDecimal getUpperBound() {
        return this.value.getUpperBound();
    }

    @Override
    @JsonIgnore
    public String getUnit() {
        return this.value.getUnit();
    }

    @Override
    @JsonIgnore
    public ItemIdValue getUnitItemId() {
        String unit = this.value.getUnit();
        if (unit.equals("1")) {
            return null;
        }
        return ItemIdValueImpl.fromIri(unit);
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsQuantityValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JacksonInnerQuantity {
        private final BigDecimal amount;
        private final BigDecimal upperBound;
        private final BigDecimal lowerBound;
        private final String unit;

        @JsonCreator
        JacksonInnerQuantity(@JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="lowerBound") BigDecimal lowerBound, @JsonProperty(value="upperBound") BigDecimal upperBound, @JsonProperty(value="unit") String unit) {
            Validate.notNull((Object)amount, (String)"Numeric value cannot be null", (Object[])new Object[0]);
            Validate.notNull((Object)unit, (String)"Unit cannot be null", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)unit, (String)"Unit cannot be empty. Use \"1\" for unit-less quantities.", (Object[])new Object[0]);
            if (lowerBound != null || upperBound != null) {
                Validate.notNull((Object)lowerBound, (String)"Lower and upper bounds should be null at the same time", (Object[])new Object[0]);
                Validate.notNull((Object)upperBound, (String)"Lower and upper bounds should be null at the same time", (Object[])new Object[0]);
                if (lowerBound.compareTo(amount) > 0) {
                    throw new IllegalArgumentException("Lower bound cannot be strictly greater than numeric value");
                }
                if (amount.compareTo(upperBound) > 0) {
                    throw new IllegalArgumentException("Upper bound cannot be strictly smaller than numeric value");
                }
            }
            this.amount = amount;
            this.upperBound = upperBound;
            this.lowerBound = lowerBound;
            this.unit = unit;
        }

        @JsonIgnore
        BigDecimal getAmount() {
            return this.amount;
        }

        @JsonIgnore
        BigDecimal getUpperBound() {
            return this.upperBound;
        }

        @JsonIgnore
        BigDecimal getLowerBound() {
            return this.lowerBound;
        }

        @JsonProperty(value="amount")
        String getAmountAsString() {
            return this.bigDecimalToSignedString(this.amount);
        }

        @JsonProperty(value="upperBound")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String getUpperBoundAsString() {
            return this.upperBound != null ? this.bigDecimalToSignedString(this.upperBound) : null;
        }

        @JsonProperty(value="lowerBound")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String getLowerBoundAsString() {
            return this.lowerBound != null ? this.bigDecimalToSignedString(this.lowerBound) : null;
        }

        @JsonProperty(value="unit")
        String getUnit() {
            return this.unit;
        }

        private String bigDecimalToSignedString(BigDecimal value) {
            if (value.signum() < 0) {
                return value.toString();
            }
            return "+" + value.toString();
        }
    }
}

