/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.LexemeIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
public class SenseIdValueImpl
extends ValueImpl
implements SenseIdValue {
    private static final Pattern PATTERN = Pattern.compile("^L[1-9]\\d*-S[1-9]\\d*$");
    private final String id;
    private final String siteIri;

    SenseIdValueImpl(String id, String siteIri) {
        super("wikibase-entityid");
        if (id == null || !PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("The string " + id + " is not a valid form id");
        }
        this.id = id;
        Validate.notNull((Object)siteIri);
        this.siteIri = siteIri;
    }

    @JsonCreator
    SenseIdValueImpl(@JsonProperty(value="value") JacksonInnerEntityId value, @JacksonInject(value="siteIri") String siteIri) {
        this(value.getStringId(), siteIri);
    }

    @Override
    @JsonIgnore
    public String getEntityType() {
        return "http://www.wikidata.org/ontology#Sense";
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @Override
    @JsonIgnore
    public String getSiteIri() {
        return this.siteIri;
    }

    @Override
    @JsonIgnore
    public String getIri() {
        return this.siteIri + this.id;
    }

    @JsonProperty(value="value")
    JacksonInnerEntityId getValue() {
        return new JacksonInnerEntityId(this.id);
    }

    @Override
    @JsonIgnore
    public LexemeIdValue getLexemeId() {
        return new LexemeIdValueImpl(this.id.substring(0, this.id.indexOf("-")), this.siteIri);
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsEntityIdValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JacksonInnerEntityId {
        private final String id;

        @JsonCreator
        JacksonInnerEntityId(@JsonProperty(value="id") String id) {
            this.id = id;
        }

        @JsonProperty(value="entity-type")
        String getJsonEntityType() {
            return "sense";
        }

        @JsonProperty(value="id")
        String getStringId() {
            return this.id;
        }
    }
}

