/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.TermedDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemUpdate;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class ItemUpdateBuilder
extends TermedDocumentUpdateBuilder {
    private final Map<String, SiteLink> modifiedSiteLinks = new HashMap<String, SiteLink>();
    private final Set<String> removedSiteLinks = new HashSet<String>();

    private ItemUpdateBuilder(ItemIdValue itemId, long revisionId) {
        super(itemId, revisionId);
    }

    private ItemUpdateBuilder(ItemDocument revision) {
        super(revision);
    }

    public static ItemUpdateBuilder forBaseRevisionId(ItemIdValue itemId, long revisionId) {
        return new ItemUpdateBuilder(itemId, revisionId);
    }

    public static ItemUpdateBuilder forEntityId(ItemIdValue itemId) {
        return new ItemUpdateBuilder(itemId, 0L);
    }

    public static ItemUpdateBuilder forBaseRevision(ItemDocument revision) {
        return new ItemUpdateBuilder(revision);
    }

    @Override
    ItemIdValue getEntityId() {
        return (ItemIdValue)super.getEntityId();
    }

    @Override
    ItemDocument getBaseRevision() {
        return (ItemDocument)super.getBaseRevision();
    }

    @Override
    public ItemUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    @Override
    public ItemUpdateBuilder updateLabels(TermUpdate update) {
        super.updateLabels(update);
        return this;
    }

    @Override
    public ItemUpdateBuilder updateDescriptions(TermUpdate update) {
        super.updateDescriptions(update);
        return this;
    }

    @Override
    public ItemUpdateBuilder updateAliases(String language, AliasUpdate update) {
        super.updateAliases(language, update);
        return this;
    }

    public ItemUpdateBuilder putSiteLink(SiteLink link) {
        SiteLink original;
        Objects.requireNonNull(link, "Site link cannot be null.");
        if (this.getBaseRevision() != null && link.equals(original = this.getBaseRevision().getSiteLinks().get(link.getSiteKey()))) {
            this.modifiedSiteLinks.remove(link.getSiteKey());
            this.removedSiteLinks.remove(link.getSiteKey());
            return this;
        }
        this.modifiedSiteLinks.put(link.getSiteKey(), link);
        this.removedSiteLinks.remove(link.getSiteKey());
        return this;
    }

    public ItemUpdateBuilder removeSiteLink(String site) {
        Validate.notBlank((CharSequence)site, (String)"Site key cannot be null.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null && !this.getBaseRevision().getSiteLinks().containsKey(site)) {
            this.modifiedSiteLinks.remove(site);
            return this;
        }
        this.removedSiteLinks.add(site);
        this.modifiedSiteLinks.remove(site);
        return this;
    }

    public ItemUpdateBuilder append(ItemUpdate update) {
        super.append(update);
        for (SiteLink link : update.getModifiedSiteLinks().values()) {
            this.putSiteLink(link);
        }
        for (String site : update.getRemovedSiteLinks()) {
            this.removeSiteLink(site);
        }
        return this;
    }

    @Override
    public ItemUpdate build() {
        return Datamodel.makeItemUpdate(this.getEntityId(), this.getBaseRevisionId(), this.labels, this.descriptions, this.aliases, this.statements, this.modifiedSiteLinks.values(), this.removedSiteLinks);
    }
}

