/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.StatementDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class SenseUpdateBuilder
extends StatementDocumentUpdateBuilder {
    private TermUpdate glosses = TermUpdate.EMPTY;

    private SenseUpdateBuilder(SenseIdValue senseId, long revisionId) {
        super(senseId, revisionId);
    }

    private SenseUpdateBuilder(SenseDocument revision) {
        super(revision);
    }

    public static SenseUpdateBuilder forBaseRevisionId(SenseIdValue senseId, long revisionId) {
        return new SenseUpdateBuilder(senseId, revisionId);
    }

    public static SenseUpdateBuilder forEntityId(SenseIdValue senseId) {
        return new SenseUpdateBuilder(senseId, 0L);
    }

    public static SenseUpdateBuilder forBaseRevision(SenseDocument revision) {
        return new SenseUpdateBuilder(revision);
    }

    @Override
    SenseIdValue getEntityId() {
        return (SenseIdValue)super.getEntityId();
    }

    @Override
    SenseDocument getBaseRevision() {
        return (SenseDocument)super.getBaseRevision();
    }

    @Override
    public SenseUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    public SenseUpdateBuilder updateGlosses(TermUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        TermUpdateBuilder combined = this.getBaseRevision() != null ? TermUpdateBuilder.forTerms(this.getBaseRevision().getGlosses().values()) : TermUpdateBuilder.create();
        combined.append(this.glosses);
        combined.append(update);
        this.glosses = combined.build();
        return this;
    }

    public SenseUpdateBuilder append(SenseUpdate update) {
        super.append(update);
        this.updateGlosses(update.getGlosses());
        return this;
    }

    @Override
    public SenseUpdate build() {
        return Datamodel.makeSenseUpdate(this.getEntityId(), this.getBaseRevisionId(), this.glosses, this.statements);
    }
}

