/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.UnsupportedValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonDeserialize
public class UnsupportedValueImpl
extends ValueImpl
implements UnsupportedValue {
    private final String typeString;
    private final Map<String, JsonNode> contents;

    @JsonCreator
    private UnsupportedValueImpl(@JsonProperty(value="type") String typeString) {
        super(typeString);
        this.typeString = typeString;
        this.contents = new HashMap<String, JsonNode>();
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    @Override
    @JsonProperty(value="type")
    public String getTypeJsonString() {
        return this.typeString;
    }

    @JsonAnyGetter
    protected Map<String, JsonNode> getContents() {
        return this.contents;
    }

    @JsonAnySetter
    protected void loadContents(String key, JsonNode value) {
        this.contents.put(key, value);
    }

    public String toString() {
        return ToString.toString(this);
    }

    public int hashCode() {
        return this.typeString.hashCode() + 31 * this.contents.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof UnsupportedValueImpl)) {
            return false;
        }
        UnsupportedValueImpl otherValue = (UnsupportedValueImpl)other;
        return this.typeString.equals(otherValue.getTypeJsonString()) && this.contents.equals(otherValue.getContents());
    }
}

