/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.wikidata.wdtk.datamodel.helpers.EntityUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.FormUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.LabeledDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.LexemeUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.SenseUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.StatementUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;

public abstract class StatementDocumentUpdateBuilder
extends EntityUpdateBuilder {
    StatementUpdate statements = StatementUpdate.EMPTY;

    protected StatementDocumentUpdateBuilder(EntityIdValue entityId, long revisionId) {
        super(entityId, revisionId);
    }

    protected StatementDocumentUpdateBuilder(StatementDocument revision) {
        super(revision);
    }

    public static StatementDocumentUpdateBuilder forBaseRevisionId(EntityIdValue entityId, long revisionId) {
        Objects.requireNonNull(entityId, "Entity ID cannot be null.");
        if (entityId instanceof SenseIdValue) {
            return SenseUpdateBuilder.forBaseRevisionId((SenseIdValue)entityId, revisionId);
        }
        if (entityId instanceof FormIdValue) {
            return FormUpdateBuilder.forBaseRevisionId((FormIdValue)entityId, revisionId);
        }
        if (entityId instanceof LexemeIdValue) {
            return LexemeUpdateBuilder.forBaseRevisionId((LexemeIdValue)entityId, revisionId);
        }
        return LabeledDocumentUpdateBuilder.forBaseRevisionId(entityId, revisionId);
    }

    public static StatementDocumentUpdateBuilder forEntityId(EntityIdValue entityId) {
        return StatementDocumentUpdateBuilder.forBaseRevisionId(entityId, 0L);
    }

    public static StatementDocumentUpdateBuilder forBaseRevision(StatementDocument revision) {
        Objects.requireNonNull(revision, "Base entity revision cannot be null.");
        if (revision instanceof SenseDocument) {
            return SenseUpdateBuilder.forBaseRevision((SenseDocument)revision);
        }
        if (revision instanceof FormDocument) {
            return FormUpdateBuilder.forBaseRevision((FormDocument)revision);
        }
        if (revision instanceof LexemeDocument) {
            return LexemeUpdateBuilder.forBaseRevision((LexemeDocument)revision);
        }
        if (revision instanceof LabeledStatementDocument) {
            return LabeledDocumentUpdateBuilder.forBaseRevision((LabeledStatementDocument)revision);
        }
        throw new IllegalArgumentException("Unrecognized entity document type.");
    }

    @Override
    StatementDocument getBaseRevision() {
        return (StatementDocument)super.getBaseRevision();
    }

    public StatementDocumentUpdateBuilder updateStatements(StatementUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        StatementUpdateBuilder combined = this.getBaseRevision() != null ? StatementUpdateBuilder.forStatementGroups(this.getEntityId(), this.getBaseRevision().getStatementGroups()) : StatementUpdateBuilder.create(this.getEntityId());
        combined.append(this.statements);
        combined.append(update);
        this.statements = combined.build();
        return this;
    }

    void append(StatementDocumentUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        this.updateStatements(update.getStatements());
    }

    @Override
    public abstract StatementDocumentUpdate build();
}

