/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SiteLinkImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.implementation.TermedStatementDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ItemDocumentImpl
extends TermedStatementDocumentImpl
implements ItemDocument {
    @JsonDeserialize(contentAs=SiteLinkImpl.class)
    private final Map<String, SiteLink> sitelinks;

    public ItemDocumentImpl(ItemIdValue id, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statements, List<SiteLink> siteLinks, long revisionId) {
        super((EntityIdValue)id, labels, descriptions, aliases, statements, revisionId);
        this.sitelinks = new HashMap<String, SiteLink>();
        for (SiteLink sitelink : siteLinks) {
            if (this.sitelinks.containsKey(sitelink.getSiteKey())) {
                throw new IllegalArgumentException("Multiple site links provided for the same site.");
            }
            this.sitelinks.put(sitelink.getSiteKey(), sitelink);
        }
    }

    @JsonCreator
    public ItemDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="labels") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> labels, @JsonProperty(value="descriptions") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> descriptions, @JsonProperty(value="aliases") @JsonDeserialize(using=TermedStatementDocumentImpl.AliasesDeserializer.class) Map<String, List<MonolingualTextValue>> aliases, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="sitelinks") Map<String, SiteLink> sitelinks, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, labels, descriptions, aliases, claims, revisionId, siteIri);
        this.sitelinks = sitelinks != null ? sitelinks : Collections.emptyMap();
    }

    protected ItemDocumentImpl(ItemIdValue subject, Map<String, MonolingualTextValue> labels, Map<String, MonolingualTextValue> descriptions, Map<String, List<MonolingualTextValue>> aliases, Map<String, List<Statement>> claims, Map<String, SiteLink> siteLinks, long revisionId) {
        super((EntityIdValue)subject, labels, descriptions, aliases, claims, revisionId);
        this.sitelinks = siteLinks;
    }

    @Override
    @JsonIgnore
    public ItemIdValue getEntityId() {
        return new ItemIdValueImpl(this.entityId, this.siteIri);
    }

    @Override
    @JsonProperty(value="sitelinks")
    public Map<String, SiteLink> getSiteLinks() {
        return Collections.unmodifiableMap(this.sitelinks);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsItemDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public ItemDocument withEntityId(ItemIdValue itemId) {
        return new ItemDocumentImpl(itemId, (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, this.sitelinks, this.revisionId);
    }

    @Override
    public ItemDocument withRevisionId(long newRevisionId) {
        return new ItemDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, this.sitelinks, newRevisionId);
    }

    @Override
    public ItemDocument withLabel(MonolingualTextValue newLabel) {
        return new ItemDocumentImpl(this.getEntityId(), ItemDocumentImpl.withTerm(this.labels, newLabel), (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, this.sitelinks, this.revisionId);
    }

    @Override
    public ItemDocument withDescription(MonolingualTextValue newDescription) {
        return new ItemDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, ItemDocumentImpl.withTerm(this.descriptions, newDescription), (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, this.sitelinks, this.revisionId);
    }

    @Override
    public ItemDocument withAliases(String language, List<MonolingualTextValue> aliases) {
        return new ItemDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, ItemDocumentImpl.withAliases(this.aliases, language, aliases), this.claims, this.sitelinks, this.revisionId);
    }

    @Override
    public ItemDocument withStatement(Statement statement) {
        Map<String, List<Statement>> newGroups = ItemDocumentImpl.addStatementToGroups(statement, this.claims);
        return new ItemDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, newGroups, this.sitelinks, this.revisionId);
    }

    @Override
    public ItemDocument withoutStatementIds(Set<String> statementIds) {
        Map<String, List<Statement>> newGroups = ItemDocumentImpl.removeStatements(statementIds, this.claims);
        return new ItemDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, newGroups, this.sitelinks, this.revisionId);
    }
}

