/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.EntityIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
public class PropertyIdValueImpl
extends EntityIdValueImpl
implements PropertyIdValue {
    public PropertyIdValueImpl(String id, String siteIri) {
        super(id, siteIri);
        this.assertHasJsonEntityType("property");
    }

    @JsonCreator
    PropertyIdValueImpl(@JsonProperty(value="value") EntityIdValueImpl.JacksonInnerEntityId value, @JacksonInject(value="siteIri") String siteIri) {
        super(value, siteIri);
        this.assertHasJsonEntityType("property");
    }

    @Override
    @JsonIgnore
    public String getEntityType() {
        return "http://www.wikidata.org/ontology#Property";
    }

    @Override
    @JsonIgnore
    public boolean isPlaceholder() {
        return this.getId().equals("P0");
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsEntityIdValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

