/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;

public class StatementUpdateImpl
implements StatementUpdate {
    @JsonIgnore
    private final List<Statement> added;
    @JsonIgnore
    private final Map<String, Statement> replaced;
    @JsonIgnore
    private final Set<String> removed;

    public StatementUpdateImpl(Collection<Statement> added, Collection<Statement> replaced, Collection<String> removed) {
        Objects.requireNonNull(added, "Added statement collection cannot be null.");
        Objects.requireNonNull(replaced, "Replaced statement collection cannot be null.");
        Objects.requireNonNull(removed, "Removed statement collection cannot be null.");
        for (Statement statement : added) {
            Objects.requireNonNull(statement, "Added statement cannot be null.");
            Validate.isTrue((boolean)statement.getStatementId().isEmpty(), (String)"Added statement cannot have an ID.", (Object[])new Object[0]);
        }
        for (Statement statement : replaced) {
            Objects.requireNonNull(statement, "Replaced statement cannot be null.");
            Validate.notBlank((CharSequence)statement.getStatementId(), (String)"Replaced statement must have an ID.", (Object[])new Object[0]);
        }
        for (String id : removed) {
            Validate.notBlank((CharSequence)id, (String)"Removed statement ID cannot be null or blank.", (Object[])new Object[0]);
        }
        long distinctIds = Stream.concat(replaced.stream().map(s -> s.getStatementId()), removed.stream()).distinct().count();
        Validate.isTrue(((long)(replaced.size() + removed.size()) == distinctIds ? 1 : 0) != 0, (String)"Statement IDs must be unique.", (Object[])new Object[0]);
        Validate.isTrue((Stream.concat(added.stream(), replaced.stream()).map(s -> s.getSubject()).distinct().count() <= 1L ? 1 : 0) != 0, (String)"All statements must have the same subject.", (Object[])new Object[0]);
        EntityIdValue subject = Stream.concat(added.stream(), replaced.stream()).map(s -> s.getSubject()).findFirst().orElse(null);
        Validate.isTrue((subject == null || !subject.isPlaceholder() ? 1 : 0) != 0, (String)"Cannot update entity with placeholder ID.", (Object[])new Object[0]);
        this.added = Collections.unmodifiableList(new ArrayList<Statement>(added));
        this.replaced = Collections.unmodifiableMap(replaced.stream().collect(Collectors.toMap(s -> s.getStatementId(), s -> s)));
        this.removed = Collections.unmodifiableSet(new HashSet<String>(removed));
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.added.isEmpty() && this.replaced.isEmpty() && this.removed.isEmpty();
    }

    @Override
    @JsonIgnore
    public List<Statement> getAdded() {
        return this.added;
    }

    @Override
    @JsonIgnore
    public Map<String, Statement> getReplaced() {
        return this.replaced;
    }

    @Override
    @JsonIgnore
    public Set<String> getRemoved() {
        return this.removed;
    }

    @JsonValue
    List<Object> toJson() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.added);
        list.addAll(this.replaced.values());
        for (String id : this.removed) {
            list.add(new RemovedStatement(id));
        }
        return list;
    }

    public boolean equals(Object obj) {
        return Equality.equalsStatementUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    static class RemovedStatement {
        private final String id;

        RemovedStatement(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="remove")
        String getRemoveCommand() {
            return "";
        }
    }
}

