/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.MonolingualTextValueImpl;
import org.wikidata.wdtk.datamodel.implementation.SnakImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ValueSnakImpl
extends SnakImpl
implements ValueSnak {
    @JsonDeserialize(as=ValueImpl.class)
    private final Value datavalue;
    private final String datatype;

    public ValueSnakImpl(PropertyIdValue property, Value value) {
        super(property);
        Validate.notNull((Object)value, (String)"A datavalue must be provided to create a value snak.", (Object[])new Object[0]);
        this.datavalue = value instanceof TermImpl ? new MonolingualTextValueImpl(((TermImpl)value).getText(), ((TermImpl)value).getLanguageCode()) : value;
        this.datatype = ValueSnakImpl.getJsonPropertyTypeForValueType(this.datavalue);
    }

    @JsonCreator
    protected ValueSnakImpl(@JsonProperty(value="property") String property, @JsonProperty(value="datatype") String datatype, @JsonProperty(value="datavalue") Value datavalue, @JacksonInject(value="siteIri") String siteIri) {
        super(property, siteIri);
        Validate.notNull((Object)datavalue, (String)"A datavalue must be provided to create a value snak.", (Object[])new Object[0]);
        this.datavalue = datavalue;
        this.datatype = datatype;
    }

    @JsonProperty(value="datavalue")
    public Value getDatavalue() {
        return this.datavalue;
    }

    @Override
    @JsonIgnore
    public Value getValue() {
        return this.datavalue;
    }

    @JsonProperty(value="datatype")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    @JsonProperty(value="snaktype")
    public String getSnakType() {
        return "value";
    }

    @Override
    public <T> T accept(SnakVisitor<T> snakVisitor) {
        return snakVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsValueSnak(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    protected static String getJsonPropertyTypeForValueType(Value value) {
        if (value instanceof TimeValue) {
            return "time";
        }
        if (value instanceof ItemIdValue) {
            return "wikibase-item";
        }
        if (value instanceof PropertyIdValue) {
            return "wikibase-property";
        }
        if (value instanceof StringValue) {
            return null;
        }
        if (value instanceof GlobeCoordinatesValue) {
            return "globe-coordinate";
        }
        if (value instanceof QuantityValue) {
            return "quantity";
        }
        if (value instanceof MonolingualTextValue) {
            return "monolingualtext";
        }
        throw new UnsupportedOperationException("Unsupported value type " + value.getClass());
    }
}

