/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityRedirectDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityUpdate;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemUpdate;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyUpdate;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class Hash {
    private static final int PRIME = 31;

    public static int hashCode(EntityIdValue o) {
        int result = o.getId().hashCode();
        result = 31 * result + o.getSiteIri().hashCode();
        result = 31 * result + o.getEntityType().hashCode();
        return result;
    }

    public static int hashCode(DatatypeIdValue o) {
        return o.getIri().hashCode();
    }

    public static int hashCode(TimeValue o) {
        int result = Long.hashCode(o.getYear());
        result = 31 * result + o.getMonth();
        result = 31 * result + o.getDay();
        result = 31 * result + o.getHour();
        result = 31 * result + o.getMinute();
        result = 31 * result + o.getSecond();
        result = 31 * result + o.getPrecision();
        result = 31 * result + o.getBeforeTolerance();
        result = 31 * result + o.getAfterTolerance();
        result = 31 * result + o.getTimezoneOffset();
        result = 31 * result + o.getPreferredCalendarModel().hashCode();
        return result;
    }

    public static int hashCode(GlobeCoordinatesValue o) {
        int result = o.getGlobe().hashCode();
        long value = Double.valueOf(o.getLatitude()).hashCode();
        result = 31 * result + (int)(value ^ value >>> 32);
        value = Double.valueOf(o.getLongitude()).hashCode();
        result = 31 * result + (int)(value ^ value >>> 32);
        value = Double.valueOf(o.getPrecision()).hashCode();
        result = 31 * result + (int)(value ^ value >>> 32);
        return result;
    }

    public static int hashCode(StringValue o) {
        return o.getString().hashCode();
    }

    public static int hashCode(MonolingualTextValue o) {
        int result = o.getLanguageCode().hashCode();
        result = 31 * result + o.getText().hashCode();
        return result;
    }

    public static int hashCode(QuantityValue o) {
        int result = o.getNumericValue().hashCode();
        result = 31 * result + o.getUnit().hashCode();
        if (o.getLowerBound() != null) {
            result = 31 * result + o.getLowerBound().hashCode();
        }
        if (o.getUpperBound() != null) {
            result = 31 * result + o.getUpperBound().hashCode();
        }
        return result;
    }

    public static int hashCode(ValueSnak o) {
        int result = o.getValue().hashCode();
        result = 31 * result + o.getPropertyId().hashCode();
        return result;
    }

    public static int hashCode(SomeValueSnak o) {
        return o.getPropertyId().hashCode();
    }

    public static int hashCode(NoValueSnak o) {
        return o.getPropertyId().hashCode();
    }

    public static int hashCode(SnakGroup o) {
        return o.getSnaks().hashCode();
    }

    public static int hashCode(Claim o) {
        int result = o.getSubject().hashCode();
        result = 31 * result + o.getMainSnak().hashCode();
        result = 31 * result + o.getQualifiers().hashCode();
        return result;
    }

    public static int hashCode(Reference o) {
        return o.getSnakGroups().hashCode();
    }

    public static int hashCode(Statement o) {
        int result = o.getSubject().hashCode();
        result = 31 * result + o.getMainSnak().hashCode();
        result = 31 * result + o.getQualifiers().hashCode();
        result = 31 * result + o.getReferences().hashCode();
        result = 31 * result + o.getRank().hashCode();
        result = 31 * result + o.getStatementId().hashCode();
        return result;
    }

    public static int hashCode(StatementGroup o) {
        return o.getStatements().hashCode();
    }

    public static int hashCode(SiteLink o) {
        int result = o.getBadges().hashCode();
        result = 31 * result + o.getPageTitle().hashCode();
        result = 31 * result + o.getSiteKey().hashCode();
        return result;
    }

    public static int hashCode(PropertyDocument o) {
        int result = Hash.hashCodeForTermedDocument(o);
        result = 31 * result + o.getStatementGroups().hashCode();
        result = 31 * result + o.getDatatype().hashCode();
        return result;
    }

    public static int hashCode(ItemDocument o) {
        int result = Hash.hashCodeForTermedDocument(o);
        result = 31 * result + o.getStatementGroups().hashCode();
        result = 31 * result + o.getSiteLinks().hashCode();
        return result;
    }

    public static int hashCode(LexemeDocument o) {
        int result = o.getLexicalCategory().hashCode();
        result = 31 * result + o.getLanguage().hashCode();
        result = 31 * result + o.getLemmas().hashCode();
        result = 31 * result + Long.hashCode(o.getRevisionId());
        result = 31 * result + o.getStatementGroups().hashCode();
        return result;
    }

    public static int hashCode(FormDocument o) {
        int result = o.getGrammaticalFeatures().hashCode();
        result = 31 * result + o.getRepresentations().hashCode();
        result = 31 * result + Long.hashCode(o.getRevisionId());
        result = 31 * result + o.getStatementGroups().hashCode();
        return result;
    }

    public static int hashCode(SenseDocument o) {
        int result = o.getGlosses().hashCode();
        result = 31 * result + Long.hashCode(o.getRevisionId());
        result = 31 * result + o.getStatementGroups().hashCode();
        return result;
    }

    public static int hashCode(MediaInfoDocument o) {
        int result = o.getLabels().hashCode();
        result = 31 * result + o.getStatementGroups().hashCode();
        return result;
    }

    private static int hashCodeForTermedDocument(TermedDocument o) {
        int result = o.getAliases().hashCode();
        result = 31 * result + o.getDescriptions().hashCode();
        result = 31 * result + o.getLabels().hashCode();
        result = 31 * result + Long.hashCode(o.getRevisionId());
        return result;
    }

    public static int hashCode(EntityRedirectDocument o) {
        int result = o.getEntityId().hashCode();
        result = 31 * result + o.getTargetId().hashCode();
        result = 31 * result + Long.hashCode(o.getRevisionId());
        return result;
    }

    public static int hashCode(TermUpdate o) {
        return Objects.hash(o.getModified(), o.getRemoved());
    }

    public static int hashCode(AliasUpdate o) {
        return Objects.hash(o.getRecreated(), o.getAdded(), o.getRemoved());
    }

    public static int hashCode(StatementUpdate o) {
        return Objects.hash(o.getAdded(), o.getReplaced(), o.getRemoved());
    }

    private static int hashCodeForEntityUpdate(EntityUpdate o) {
        return Objects.hash(o.getEntityId(), o.getBaseRevisionId());
    }

    private static int hashCodeForStatementDocumentUpdate(StatementDocumentUpdate o) {
        return Hash.hashCodeForEntityUpdate(o) * 31 + Objects.hash(o.getStatements());
    }

    private static int hashCodeForLabeledStatementDocumentUpdate(LabeledStatementDocumentUpdate o) {
        return Hash.hashCodeForStatementDocumentUpdate(o) * 31 + Objects.hash(o.getLabels());
    }

    private static int hashCodeForTermedStatementDocumentUpdate(TermedStatementDocumentUpdate o) {
        return Hash.hashCodeForLabeledStatementDocumentUpdate(o) * 31 + Objects.hash(o.getDescriptions(), o.getAliases());
    }

    public static int hashCode(MediaInfoUpdate o) {
        return Hash.hashCodeForLabeledStatementDocumentUpdate(o);
    }

    public static int hashCode(ItemUpdate o) {
        return Hash.hashCodeForTermedStatementDocumentUpdate(o) * 31 + Objects.hash(o.getModifiedSiteLinks(), o.getRemovedSiteLinks());
    }

    public static int hashCode(PropertyUpdate o) {
        return Hash.hashCodeForTermedStatementDocumentUpdate(o);
    }

    public static int hashCode(SenseUpdate o) {
        return Hash.hashCodeForStatementDocumentUpdate(o) * 31 + Objects.hash(o.getGlosses());
    }

    public static int hashCode(FormUpdate o) {
        return Hash.hashCodeForStatementDocumentUpdate(o) * 31 + Objects.hash(o.getRepresentations(), o.getGrammaticalFeatures());
    }

    public static int hashCode(LexemeUpdate o) {
        return Hash.hashCodeForStatementDocumentUpdate(o) * 31 + Objects.hash(o.getLanguage(), o.getLexicalCategory(), o.getLemmas(), o.getAddedSenses(), o.getUpdatedSenses(), o.getRemovedSenses(), o.getAddedForms(), o.getUpdatedForms(), o.getRemovedForms());
    }
}

