/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Iterator;
import java.util.List;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.Value;

public class ClaimImpl
implements Claim {
    private final Statement statement;

    public ClaimImpl(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        this.statement = new StatementImpl(null, StatementRank.NORMAL, mainSnak, qualifiers, null, subject);
    }

    public ClaimImpl(StatementImpl statement) {
        this.statement = statement;
    }

    @Override
    public EntityIdValue getSubject() {
        return this.statement.getSubject();
    }

    @Override
    public Snak getMainSnak() {
        return this.statement.getMainSnak();
    }

    @Override
    public List<SnakGroup> getQualifiers() {
        return this.statement.getQualifiers();
    }

    @Override
    public Iterator<Snak> getAllQualifiers() {
        return this.statement.getAllQualifiers();
    }

    @Override
    public Value getValue() {
        return this.statement.getValue();
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsClaim(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

