/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityUpdate;

public abstract class EntityUpdateImpl
implements EntityUpdate {
    @JsonIgnore
    private final EntityIdValue entityId;
    @JsonIgnore
    private final long revisionId;

    protected EntityUpdateImpl(EntityIdValue entityId, long revisionId) {
        Objects.requireNonNull(entityId, "Entity ID cannot be null.");
        Validate.isTrue((!entityId.isPlaceholder() ? 1 : 0) != 0, (String)"Cannot create update for placeholder entity ID.", (Object[])new Object[0]);
        this.entityId = entityId;
        this.revisionId = revisionId;
    }

    @Override
    @JsonIgnore
    public EntityIdValue getEntityId() {
        return this.entityId;
    }

    @Override
    @JsonIgnore
    public long getBaseRevisionId() {
        return this.revisionId;
    }
}

