/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.EntityRedirectDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.MediaInfoDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityRedirectDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;

public class JsonDeserializer {
    private ObjectReader entityDocumentReader;
    private ObjectReader itemReader;
    private ObjectReader propertyReader;
    private ObjectReader lexemeReader;
    private ObjectReader mediaInfoReader;
    private ObjectReader entityRedirectReader;

    public JsonDeserializer(String siteIri) {
        DatamodelMapper mapper = new DatamodelMapper(siteIri);
        this.entityDocumentReader = mapper.readerFor(EntityDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.itemReader = mapper.readerFor(ItemDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.propertyReader = mapper.readerFor(PropertyDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.lexemeReader = mapper.readerFor(LexemeDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.mediaInfoReader = mapper.readerFor(MediaInfoDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.entityRedirectReader = mapper.readerFor(EntityRedirectDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
    }

    public ItemDocument deserializeItemDocument(String json) throws JsonProcessingException {
        return (ItemDocument)this.itemReader.readValue(json);
    }

    public PropertyDocument deserializePropertyDocument(String json) throws JsonProcessingException {
        return (PropertyDocument)this.propertyReader.readValue(json);
    }

    public LexemeDocument deserializeLexemeDocument(String json) throws JsonProcessingException {
        return (LexemeDocument)this.lexemeReader.readValue(json);
    }

    public MediaInfoDocument deserializeMediaInfoDocument(String json) throws JsonProcessingException {
        return (MediaInfoDocument)this.mediaInfoReader.readValue(json);
    }

    public EntityDocument deserializeEntityDocument(String json) throws JsonProcessingException {
        return (EntityDocument)this.entityDocumentReader.readValue(json);
    }

    public EntityRedirectDocument deserializeEntityRedirectDocument(String json) throws JsonProcessingException {
        return (EntityRedirectDocument)this.entityRedirectReader.readValue(json);
    }
}

