/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.wikidata.wdtk.datamodel.helpers.MediaInfoUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.StatementDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermedDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;

public abstract class LabeledDocumentUpdateBuilder
extends StatementDocumentUpdateBuilder {
    TermUpdate labels = TermUpdate.EMPTY;

    protected LabeledDocumentUpdateBuilder(EntityIdValue entityId, long revisionId) {
        super(entityId, revisionId);
    }

    protected LabeledDocumentUpdateBuilder(LabeledStatementDocument revision) {
        super(revision);
    }

    public static LabeledDocumentUpdateBuilder forBaseRevisionId(EntityIdValue entityId, long revisionId) {
        Objects.requireNonNull(entityId, "Entity ID cannot be null.");
        if (entityId instanceof MediaInfoIdValue) {
            return MediaInfoUpdateBuilder.forBaseRevisionId((MediaInfoIdValue)entityId, revisionId);
        }
        return TermedDocumentUpdateBuilder.forBaseRevisionId(entityId, revisionId);
    }

    public static LabeledDocumentUpdateBuilder forEntityId(EntityIdValue entityId) {
        return LabeledDocumentUpdateBuilder.forBaseRevisionId(entityId, 0L);
    }

    public static LabeledDocumentUpdateBuilder forBaseRevision(LabeledStatementDocument revision) {
        Objects.requireNonNull(revision, "Base entity revision cannot be null.");
        if (revision instanceof MediaInfoDocument) {
            return MediaInfoUpdateBuilder.forBaseRevision((MediaInfoDocument)revision);
        }
        if (revision instanceof TermedStatementDocument) {
            return TermedDocumentUpdateBuilder.forBaseRevision((TermedStatementDocument)revision);
        }
        throw new IllegalArgumentException("Unrecognized entity document type.");
    }

    @Override
    LabeledStatementDocument getBaseRevision() {
        return (LabeledStatementDocument)super.getBaseRevision();
    }

    @Override
    public LabeledDocumentUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    public LabeledDocumentUpdateBuilder updateLabels(TermUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        TermUpdateBuilder combined = this.getBaseRevision() != null ? TermUpdateBuilder.forTerms(this.getBaseRevision().getLabels().values()) : TermUpdateBuilder.create();
        combined.append(this.labels);
        combined.append(update);
        this.labels = combined.build();
        return this;
    }

    void append(LabeledStatementDocumentUpdate update) {
        super.append(update);
        this.updateLabels(update.getLabels());
    }

    @Override
    public abstract LabeledStatementDocumentUpdate build();
}

