/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;

public class AliasUpdateBuilder {
    private String languageCode;
    private final List<MonolingualTextValue> base;
    private List<MonolingualTextValue> recreated;
    private final List<MonolingualTextValue> added = new ArrayList<MonolingualTextValue>();
    private final Set<MonolingualTextValue> removed = new HashSet<MonolingualTextValue>();

    private AliasUpdateBuilder(List<MonolingualTextValue> base) {
        if (base != null) {
            for (MonolingualTextValue alias : base) {
                Objects.requireNonNull(alias, "Base document aliases cannot be null.");
            }
            Validate.isTrue((base.stream().map(v -> v.getLanguageCode()).distinct().count() <= 1L ? 1 : 0) != 0, (String)"Base document aliases must have the same language code.", (Object[])new Object[0]);
            Validate.isTrue((base.stream().distinct().count() == (long)base.size() ? 1 : 0) != 0, (String)"Base document aliases must be unique.", (Object[])new Object[0]);
            this.base = new ArrayList<MonolingualTextValue>(base);
            this.languageCode = base.stream().map(v -> v.getLanguageCode()).findFirst().orElse(null);
        } else {
            this.base = null;
        }
    }

    public static AliasUpdateBuilder create() {
        return new AliasUpdateBuilder(null);
    }

    public static AliasUpdateBuilder forAliases(List<MonolingualTextValue> aliases) {
        Objects.requireNonNull(aliases, "Base document alias collection cannot be null.");
        return new AliasUpdateBuilder(aliases);
    }

    public AliasUpdateBuilder add(MonolingualTextValue alias) {
        Objects.requireNonNull(alias, "Alias cannot be null.");
        if (this.languageCode != null) {
            Validate.isTrue((boolean)this.languageCode.equals(alias.getLanguageCode()), (String)"Inconsistent language codes.", (Object[])new Object[0]);
        }
        if (this.recreated != null) {
            if (!this.recreated.contains(alias)) {
                this.recreated.add(alias);
                if (this.recreated.equals(this.base)) {
                    this.recreated = null;
                }
            }
        } else if (this.removed.contains(alias)) {
            this.removed.remove(alias);
        } else if (!(this.added.contains(alias) || this.base != null && this.base.contains(alias))) {
            this.added.add(alias);
        }
        this.languageCode = alias.getLanguageCode();
        return this;
    }

    public AliasUpdateBuilder remove(MonolingualTextValue alias) {
        Objects.requireNonNull(alias, "Alias cannot be null.");
        if (this.languageCode != null) {
            Validate.isTrue((boolean)this.languageCode.equals(alias.getLanguageCode()), (String)"Inconsistent language codes.", (Object[])new Object[0]);
        }
        if (this.recreated != null) {
            this.recreated.remove(alias);
            if (this.recreated.equals(this.base)) {
                this.recreated = null;
            }
        } else if (this.added.contains(alias)) {
            this.added.remove(alias);
        } else if (!this.removed.contains(alias) && (this.base == null || this.base.contains(alias))) {
            this.removed.add(alias);
        }
        this.languageCode = alias.getLanguageCode();
        return this;
    }

    public AliasUpdateBuilder recreate(List<MonolingualTextValue> aliases) {
        Objects.requireNonNull(aliases, "Alias list cannot be null.");
        for (MonolingualTextValue alias : aliases) {
            Objects.requireNonNull(alias, "Aliases cannot be null.");
        }
        Validate.isTrue((aliases.stream().map(v -> v.getLanguageCode()).distinct().count() <= 1L ? 1 : 0) != 0, (String)"Aliases must have the same language code.", (Object[])new Object[0]);
        Validate.isTrue((aliases.stream().map(v -> v.getText()).distinct().count() == (long)aliases.size() ? 1 : 0) != 0, (String)"All aliases must be unique.", (Object[])new Object[0]);
        if (this.languageCode != null && !aliases.isEmpty()) {
            Validate.isTrue((boolean)this.languageCode.equals(aliases.get(0).getLanguageCode()), (String)"Inconsistent language codes.", (Object[])new Object[0]);
        }
        this.added.clear();
        this.removed.clear();
        this.recreated = !aliases.equals(this.base) ? new ArrayList<MonolingualTextValue>(aliases) : null;
        if (!aliases.isEmpty()) {
            this.languageCode = aliases.get(0).getLanguageCode();
        }
        return this;
    }

    public AliasUpdateBuilder append(AliasUpdate update) {
        Objects.requireNonNull(update, "Alias update cannot be null.");
        update.getRecreated().ifPresent(this::recreate);
        for (MonolingualTextValue alias : update.getRemoved()) {
            this.remove(alias);
        }
        for (MonolingualTextValue alias : update.getAdded()) {
            this.add(alias);
        }
        return this;
    }

    public AliasUpdate build() {
        return Datamodel.makeAliasUpdate(this.recreated, this.added, this.removed);
    }
}

