/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.FormUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.SenseUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.StatementDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeUpdate;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class LexemeUpdateBuilder
extends StatementDocumentUpdateBuilder {
    private ItemIdValue language;
    private ItemIdValue lexicalCategory;
    private TermUpdate lemmas = TermUpdate.EMPTY;
    private final List<SenseDocument> addedSenses = new ArrayList<SenseDocument>();
    private final Map<SenseIdValue, SenseUpdate> updatedSenses = new HashMap<SenseIdValue, SenseUpdate>();
    private final Set<SenseIdValue> removedSenses = new HashSet<SenseIdValue>();
    private final List<FormDocument> addedForms = new ArrayList<FormDocument>();
    private final Map<FormIdValue, FormUpdate> updatedForms = new HashMap<FormIdValue, FormUpdate>();
    private final Set<FormIdValue> removedForms = new HashSet<FormIdValue>();

    private LexemeUpdateBuilder(LexemeIdValue lexemeId, long revisionId) {
        super(lexemeId, revisionId);
    }

    private LexemeUpdateBuilder(LexemeDocument revision) {
        super(revision);
    }

    public static LexemeUpdateBuilder forBaseRevisionId(LexemeIdValue lexemeId, long revisionId) {
        return new LexemeUpdateBuilder(lexemeId, revisionId);
    }

    public static LexemeUpdateBuilder forEntityId(LexemeIdValue lexemeId) {
        return new LexemeUpdateBuilder(lexemeId, 0L);
    }

    public static LexemeUpdateBuilder forBaseRevision(LexemeDocument revision) {
        return new LexemeUpdateBuilder(revision);
    }

    @Override
    LexemeIdValue getEntityId() {
        return (LexemeIdValue)super.getEntityId();
    }

    @Override
    LexemeDocument getBaseRevision() {
        return (LexemeDocument)super.getBaseRevision();
    }

    @Override
    public LexemeUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    public LexemeUpdateBuilder setLanguage(ItemIdValue language) {
        Objects.requireNonNull(language, "Language cannot be null.");
        Validate.isTrue((!language.isPlaceholder() ? 1 : 0) != 0, (String)"Language ID cannot be a placeholder ID.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null && this.getBaseRevision().getLanguage().equals(language)) {
            this.language = null;
            return this;
        }
        this.language = language;
        return this;
    }

    public LexemeUpdateBuilder setLexicalCategory(ItemIdValue category) {
        Objects.requireNonNull(category, "Lexical category cannot be null.");
        Validate.isTrue((!category.isPlaceholder() ? 1 : 0) != 0, (String)"Lexical category ID cannot be a placeholder ID.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null && this.getBaseRevision().getLexicalCategory().equals(category)) {
            this.lexicalCategory = null;
            return this;
        }
        this.lexicalCategory = category;
        return this;
    }

    public LexemeUpdateBuilder updateLemmas(TermUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        TermUpdateBuilder combined = this.getBaseRevision() != null ? TermUpdateBuilder.forTerms(this.getBaseRevision().getLemmas().values()) : TermUpdateBuilder.create();
        combined.append(this.lemmas);
        combined.append(update);
        this.lemmas = combined.build();
        return this;
    }

    public LexemeUpdateBuilder addSense(SenseDocument sense) {
        Objects.requireNonNull(sense, "Sense cannot be null.");
        if (!sense.getEntityId().isPlaceholder()) {
            sense = sense.withEntityId(SenseIdValue.NULL);
        }
        if (sense.getRevisionId() != 0L) {
            sense = sense.withRevisionId(0L);
        }
        this.addedSenses.add(sense);
        return this;
    }

    public LexemeUpdateBuilder updateSense(SenseUpdate update) {
        SenseUpdateBuilder builder;
        Objects.requireNonNull(update, "Sense update cannot be null.");
        SenseIdValue id = update.getEntityId();
        Validate.validState((!this.removedSenses.contains(id) ? 1 : 0) != 0, (String)"Cannot update removed sense.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null) {
            SenseDocument original = this.getBaseRevision().getSenses().stream().filter(s -> s.getEntityId().equals(id)).findFirst().orElse(null);
            Validate.isTrue((original != null ? 1 : 0) != 0, (String)"Cannot update sense that is not in the base revision.", (Object[])new Object[0]);
            builder = SenseUpdateBuilder.forBaseRevision(original.withRevisionId(this.getBaseRevisionId()));
        } else {
            builder = SenseUpdateBuilder.forBaseRevisionId(id, this.getBaseRevisionId());
        }
        SenseUpdate prior = this.updatedSenses.get(id);
        if (prior != null) {
            builder.append(prior);
        }
        builder.append(update);
        SenseUpdate combined = builder.build();
        if (!combined.isEmpty()) {
            this.updatedSenses.put(id, combined);
        } else {
            this.updatedSenses.remove(id);
        }
        return this;
    }

    public LexemeUpdateBuilder removeSense(SenseIdValue senseId) {
        Objects.requireNonNull(senseId, "Sense ID cannot be null.");
        Validate.isTrue((!senseId.isPlaceholder() ? 1 : 0) != 0, (String)"ID of removed sense cannot be a placeholder ID.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null) {
            Validate.isTrue((boolean)this.getBaseRevision().getSenses().stream().anyMatch(s -> s.getEntityId().equals(senseId)), (String)"Cannot remove sense that is not in the base revision.", (Object[])new Object[0]);
        }
        this.removedSenses.add(senseId);
        this.updatedSenses.remove(senseId);
        return this;
    }

    public LexemeUpdateBuilder addForm(FormDocument form) {
        Objects.requireNonNull(form, "Form cannot be null.");
        if (!form.getEntityId().isPlaceholder()) {
            form = form.withEntityId(FormIdValue.NULL);
        }
        if (form.getRevisionId() != 0L) {
            form = form.withRevisionId(0L);
        }
        this.addedForms.add(form);
        return this;
    }

    public LexemeUpdateBuilder updateForm(FormUpdate update) {
        FormUpdateBuilder builder;
        Objects.requireNonNull(update, "Form update cannot be null.");
        FormIdValue id = update.getEntityId();
        Validate.validState((!this.removedForms.contains(id) ? 1 : 0) != 0, (String)"Cannot update removed form.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null) {
            FormDocument original = this.getBaseRevision().getForms().stream().filter(s -> s.getEntityId().equals(id)).findFirst().orElse(null);
            Validate.isTrue((original != null ? 1 : 0) != 0, (String)"Cannot update form that is not in the base revision.", (Object[])new Object[0]);
            builder = FormUpdateBuilder.forBaseRevision(original.withRevisionId(this.getBaseRevisionId()));
        } else {
            builder = FormUpdateBuilder.forBaseRevisionId(id, this.getBaseRevisionId());
        }
        FormUpdate prior = this.updatedForms.get(id);
        if (prior != null) {
            builder.append(prior);
        }
        builder.append(update);
        FormUpdate combined = builder.build();
        if (!combined.isEmpty()) {
            this.updatedForms.put(id, combined);
        } else {
            this.updatedForms.remove(id);
        }
        return this;
    }

    public LexemeUpdateBuilder removeForm(FormIdValue formId) {
        Objects.requireNonNull(formId, "Form ID cannot be null.");
        Validate.isTrue((!formId.isPlaceholder() ? 1 : 0) != 0, (String)"ID of removed form cannot be a placeholder ID.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null) {
            Validate.isTrue((boolean)this.getBaseRevision().getForms().stream().anyMatch(s -> s.getEntityId().equals(formId)), (String)"Cannot remove form that is not in the base revision.", (Object[])new Object[0]);
        }
        this.removedForms.add(formId);
        this.updatedForms.remove(formId);
        return this;
    }

    public LexemeUpdateBuilder append(LexemeUpdate update) {
        super.append(update);
        if (update.getLanguage().isPresent()) {
            this.setLanguage(update.getLanguage().get());
        }
        if (update.getLexicalCategory().isPresent()) {
            this.setLexicalCategory(update.getLexicalCategory().get());
        }
        this.updateLemmas(update.getLemmas());
        for (SenseDocument senseDocument : update.getAddedSenses()) {
            this.addSense(senseDocument);
        }
        for (SenseUpdate senseUpdate : update.getUpdatedSenses().values()) {
            this.updateSense(senseUpdate);
        }
        for (SenseIdValue senseIdValue : update.getRemovedSenses()) {
            this.removeSense(senseIdValue);
        }
        for (FormDocument formDocument : update.getAddedForms()) {
            this.addForm(formDocument);
        }
        for (FormUpdate formUpdate : update.getUpdatedForms().values()) {
            this.updateForm(formUpdate);
        }
        for (FormIdValue formIdValue : update.getRemovedForms()) {
            this.removeForm(formIdValue);
        }
        return this;
    }

    @Override
    public LexemeUpdate build() {
        return Datamodel.makeLexemeUpdate(this.getEntityId(), this.getBaseRevisionId(), this.language, this.lexicalCategory, this.lemmas, this.statements, this.addedSenses, this.updatedSenses.values(), this.removedSenses, this.addedForms, this.updatedForms.values(), this.removedForms);
    }
}

