/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize
public class MonolingualTextValueImpl
extends ValueImpl
implements MonolingualTextValue {
    private final JacksonInnerMonolingualText value;

    public MonolingualTextValueImpl(String text, String language) {
        super("monolingualtext");
        this.value = new JacksonInnerMonolingualText(language, text);
    }

    @JsonCreator
    MonolingualTextValueImpl(@JsonProperty(value="value") JacksonInnerMonolingualText value) {
        super("monolingualtext");
        this.value = value;
    }

    public JacksonInnerMonolingualText getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public String getText() {
        return this.value.getText();
    }

    @Override
    @JsonIgnore
    public String getLanguageCode() {
        return this.value.getLanguage();
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsMonolingualTextValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JacksonInnerMonolingualText {
        private final String language;
        private final String text;

        @JsonCreator
        JacksonInnerMonolingualText(@JsonProperty(value="language") String language, @JsonProperty(value="text") String text) {
            Validate.notNull((Object)language, (String)"A language has to be provided to create a MonolingualTextValue", (Object[])new Object[0]);
            this.language = language;
            Validate.notNull((Object)text, (String)"A text has to be provided to create a MonolingualTextValue", (Object[])new Object[0]);
            this.text = text;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getText() {
            return this.text;
        }
    }
}

