/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.StatementDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;

public abstract class EntityUpdateBuilder {
    private final EntityIdValue entityId;
    private final long baseRevisionId;
    private final EntityDocument baseRevision;

    protected EntityUpdateBuilder(EntityIdValue entityId, long revisionId) {
        Objects.requireNonNull(entityId, "Entity ID cannot be null.");
        Validate.isTrue((!entityId.isPlaceholder() ? 1 : 0) != 0, (String)"Cannot create update for placeholder entity ID.", (Object[])new Object[0]);
        this.entityId = entityId;
        this.baseRevisionId = revisionId;
        this.baseRevision = null;
    }

    protected EntityUpdateBuilder(EntityDocument revision) {
        Objects.requireNonNull(revision, "Base entity revision cannot be null.");
        Validate.isTrue((!revision.getEntityId().isPlaceholder() ? 1 : 0) != 0, (String)"Cannot create update for placeholder entity ID.", (Object[])new Object[0]);
        this.entityId = revision.getEntityId();
        this.baseRevision = revision;
        this.baseRevisionId = this.baseRevision.getRevisionId();
    }

    public static EntityUpdateBuilder forBaseRevisionId(EntityIdValue entityId, long revisionId) {
        return StatementDocumentUpdateBuilder.forBaseRevisionId(entityId, revisionId);
    }

    public static EntityUpdateBuilder forEntityId(EntityIdValue entityId) {
        return EntityUpdateBuilder.forBaseRevisionId(entityId, 0L);
    }

    public static EntityUpdateBuilder forBaseRevision(EntityDocument revision) {
        Objects.requireNonNull(revision, "Base entity revision cannot be null.");
        if (revision instanceof StatementDocument) {
            return StatementDocumentUpdateBuilder.forBaseRevision((StatementDocument)revision);
        }
        throw new IllegalArgumentException("Unrecognized entity document type.");
    }

    EntityIdValue getEntityId() {
        return this.entityId;
    }

    EntityDocument getBaseRevision() {
        return this.baseRevision;
    }

    long getBaseRevisionId() {
        return this.baseRevisionId;
    }

    public abstract EntityUpdate build();
}

