/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.StatementDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class FormUpdateBuilder
extends StatementDocumentUpdateBuilder {
    private TermUpdate representations = TermUpdate.EMPTY;
    private Set<ItemIdValue> grammaticalFeatures;

    private FormUpdateBuilder(FormIdValue formId, long revisionId) {
        super(formId, revisionId);
    }

    private FormUpdateBuilder(FormDocument revision) {
        super(revision);
    }

    public static FormUpdateBuilder forBaseRevisionId(FormIdValue formId, long revisionId) {
        return new FormUpdateBuilder(formId, revisionId);
    }

    public static FormUpdateBuilder forEntityId(FormIdValue formId) {
        return new FormUpdateBuilder(formId, 0L);
    }

    public static FormUpdateBuilder forBaseRevision(FormDocument revision) {
        return new FormUpdateBuilder(revision);
    }

    @Override
    FormIdValue getEntityId() {
        return (FormIdValue)super.getEntityId();
    }

    @Override
    FormDocument getBaseRevision() {
        return (FormDocument)super.getBaseRevision();
    }

    @Override
    public FormUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    public FormUpdateBuilder updateRepresentations(TermUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        TermUpdateBuilder combined = this.getBaseRevision() != null ? TermUpdateBuilder.forTerms(this.getBaseRevision().getRepresentations().values()) : TermUpdateBuilder.create();
        combined.append(this.representations);
        combined.append(update);
        this.representations = combined.build();
        return this;
    }

    public FormUpdateBuilder setGrammaticalFeatures(Collection<ItemIdValue> features) {
        Objects.requireNonNull(features, "Collection of grammatical features cannot be null.");
        for (ItemIdValue id : features) {
            Objects.requireNonNull(id, "Grammatical feature IDs must not be null.");
            Validate.isTrue((!id.isPlaceholder() ? 1 : 0) != 0, (String)"Grammatical feature ID cannot be a placeholder ID.", (Object[])new Object[0]);
        }
        HashSet<ItemIdValue> set = new HashSet<ItemIdValue>(features);
        Validate.isTrue((set.size() == features.size() ? 1 : 0) != 0, (String)"Every grammatical feature must be unique.", (Object[])new Object[0]);
        if (this.getBaseRevision() != null && set.equals(new HashSet<ItemIdValue>(this.getBaseRevision().getGrammaticalFeatures()))) {
            this.grammaticalFeatures = null;
            return this;
        }
        this.grammaticalFeatures = new HashSet<ItemIdValue>(features);
        return this;
    }

    public FormUpdateBuilder append(FormUpdate update) {
        super.append(update);
        this.updateRepresentations(update.getRepresentations());
        if (update.getGrammaticalFeatures().isPresent()) {
            this.setGrammaticalFeatures((Collection<ItemIdValue>)update.getGrammaticalFeatures().get());
        }
        return this;
    }

    @Override
    public FormUpdate build() {
        return Datamodel.makeFormUpdate(this.getEntityId(), this.getBaseRevisionId(), this.representations, this.grammaticalFeatures, this.statements);
    }
}

