/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Arrays;
import java.util.HashMap;
import org.wikidata.wdtk.datamodel.helpers.EntityDocumentBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;

public class ItemDocumentBuilder
extends EntityDocumentBuilder<ItemDocumentBuilder, ItemDocument> {
    private final HashMap<String, SiteLink> siteLinks = new HashMap();

    protected ItemDocumentBuilder(ItemIdValue itemIdValue) {
        super(itemIdValue);
    }

    protected ItemDocumentBuilder(ItemDocument initialDocument) {
        super(initialDocument);
        for (SiteLink siteLink : initialDocument.getSiteLinks().values()) {
            this.withSiteLink(siteLink);
        }
    }

    public static ItemDocumentBuilder forItemId(ItemIdValue itemIdValue) {
        return new ItemDocumentBuilder(itemIdValue);
    }

    public static ItemDocumentBuilder fromItemDocument(ItemDocument initialDocument) {
        return new ItemDocumentBuilder(initialDocument);
    }

    @Override
    public ItemDocument build() {
        this.prepareBuild();
        return factory.getItemDocument((ItemIdValue)this.entityIdValue, this.labels, this.descriptions, this.aliases, this.getStatementGroups(), this.siteLinks, this.revisionId);
    }

    public ItemDocumentBuilder withSiteLink(SiteLink siteLink) {
        this.siteLinks.put(siteLink.getSiteKey(), siteLink);
        return this;
    }

    public ItemDocumentBuilder withSiteLink(String title, String siteKey, ItemIdValue ... badges) {
        this.withSiteLink(factory.getSiteLink(title, siteKey, Arrays.asList(badges)));
        return this;
    }

    @Override
    public ItemDocumentBuilder withEntityId(EntityIdValue entityId) {
        if (!(entityId instanceof ItemIdValue)) {
            throw new IllegalArgumentException("The entity id of an ItemDocument must be an ItemIdValue.");
        }
        return (ItemDocumentBuilder)super.withEntityId(entityId);
    }

    @Override
    protected ItemDocumentBuilder getThis() {
        return this;
    }
}

