/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wikidata.wdtk.datamodel.implementation.FormDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;

public class LexemeDeserializer
extends StdDeserializer<LexemeDocumentImpl> {
    public LexemeDeserializer() {
        super(LexemeDocumentImpl.class);
    }

    public LexemeDocumentImpl deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (!(node instanceof ObjectNode)) {
            throw new IOException("Deserializing a lexeme can only be done from a JSON object");
        }
        ObjectNode object = (ObjectNode)node;
        String jsonId = object.get("id").asText();
        String lexicalCategory = object.get("lexicalCategory").asText();
        String language = object.get("language").asText();
        TypeFactory typeFactory = deserializationContext.getTypeFactory();
        JsonNode lemmas1 = object.get("lemmas");
        Map preLemmas = (Map)deserializationContext.readTreeAsValue(lemmas1, (JavaType)typeFactory.constructMapType(Map.class, String.class, TermImpl.class));
        Map<String, MonolingualTextValue> lemmas = null;
        if (preLemmas != null) {
            lemmas = preLemmas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (MonolingualTextValue)v.getValue()));
        }
        Map claims = (Map)deserializationContext.readTreeAsValue(object.get("claims"), (JavaType)typeFactory.constructMapType(Map.class, typeFactory.constructType(String.class), (JavaType)typeFactory.constructCollectionType(List.class, StatementImpl.PreStatement.class)));
        List forms = object.get("forms") instanceof ObjectNode && ((ObjectNode)object.get("forms")).isEmpty() ? Collections.emptyList() : (List)deserializationContext.readTreeAsValue(object.get("forms"), (JavaType)typeFactory.constructCollectionType(List.class, FormDocumentImpl.class));
        List senses = object.get("senses") instanceof ObjectNode && ((ObjectNode)object.get("senses")).isEmpty() ? Collections.emptyList() : (List)deserializationContext.readTreeAsValue(object.get("senses"), (JavaType)typeFactory.constructCollectionType(List.class, SenseDocumentImpl.class));
        long lastrevid = 0L;
        if (object.has("lastrevid")) {
            lastrevid = object.get("lastrevid").asLong();
        }
        String siteIri = (String)deserializationContext.findInjectableValue((Object)"siteIri", null, null);
        return new LexemeDocumentImpl(jsonId, lexicalCategory, language, lemmas, claims, forms, senses, lastrevid, siteIri);
    }
}

