/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentUpdateImpl;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class SenseUpdateImpl
extends StatementDocumentUpdateImpl
implements SenseUpdate {
    @JsonIgnore
    private final TermUpdate glosses;

    public SenseUpdateImpl(SenseIdValue entityId, long revisionId, TermUpdate glosses, StatementUpdate statements) {
        super(entityId, revisionId, statements);
        Objects.requireNonNull(glosses, "Gloss update cannot be null.");
        this.glosses = glosses;
    }

    @Override
    @JsonIgnore
    public SenseIdValue getEntityId() {
        return (SenseIdValue)super.getEntityId();
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty() && this.glosses.isEmpty();
    }

    @Override
    @JsonIgnore
    public TermUpdate getGlosses() {
        return this.glosses;
    }

    @JsonProperty(value="glosses")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    TermUpdate getJsonGlosses() {
        return this.glosses.isEmpty() ? null : this.glosses;
    }

    public boolean equals(Object obj) {
        return Equality.equalsSenseUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }
}

