/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.dumpfiles.MwRevision;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessor;

public class WikibaseRevisionProcessor
implements MwRevisionProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikibaseRevisionProcessor.class);
    private final EntityDocumentProcessor entityDocumentProcessor;
    private final ObjectReader itemReader;
    private final ObjectReader propertyReader;
    private final ObjectReader lexemeReader;

    public WikibaseRevisionProcessor(EntityDocumentProcessor entityDocumentProcessor, String siteIri) {
        this.entityDocumentProcessor = entityDocumentProcessor;
        DatamodelMapper mapper = new DatamodelMapper(siteIri);
        this.itemReader = mapper.readerFor(ItemDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.propertyReader = mapper.readerFor(PropertyDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.lexemeReader = mapper.readerFor(LexemeDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
    }

    @Override
    public void startRevisionProcessing(String siteName, String baseUrl, Map<Integer, String> namespaces) {
    }

    @Override
    public void processRevision(MwRevision mwRevision) {
        if ("wikibase-item".equals(mwRevision.getModel())) {
            this.processItemRevision(mwRevision);
        } else if ("wikibase-property".equals(mwRevision.getModel())) {
            this.processPropertyRevision(mwRevision);
        } else if ("wikibase-lexeme".equals(mwRevision.getModel())) {
            this.processLexemeRevision(mwRevision);
        }
    }

    public void processItemRevision(MwRevision mwRevision) {
        if (this.isWikibaseRedirection(mwRevision)) {
            return;
        }
        try {
            ItemDocument document = (ItemDocument)this.itemReader.readValue(mwRevision.getText());
            this.entityDocumentProcessor.processItemDocument(document);
        }
        catch (JsonParseException e1) {
            logger.error("Failed to parse JSON for item " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
        }
        catch (JsonMappingException e1) {
            logger.error("Failed to map JSON for item " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
            e1.printStackTrace();
            System.out.print(mwRevision.getText());
        }
        catch (IOException e1) {
            logger.error("Failed to read revision: " + e1.getMessage());
        }
    }

    public void processPropertyRevision(MwRevision mwRevision) {
        if (this.isWikibaseRedirection(mwRevision)) {
            return;
        }
        try {
            PropertyDocument document = (PropertyDocument)this.propertyReader.readValue(mwRevision.getText());
            this.entityDocumentProcessor.processPropertyDocument(document);
        }
        catch (JsonParseException e1) {
            logger.error("Failed to parse JSON for property " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
        }
        catch (JsonMappingException e1) {
            logger.error("Failed to map JSON for property " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
            e1.printStackTrace();
            System.out.print(mwRevision.getText());
        }
        catch (IOException e1) {
            logger.error("Failed to read revision: " + e1.getMessage());
        }
    }

    private void processLexemeRevision(MwRevision mwRevision) {
        if (this.isWikibaseRedirection(mwRevision)) {
            return;
        }
        try {
            LexemeDocument document = (LexemeDocument)this.lexemeReader.readValue(mwRevision.getText());
            this.entityDocumentProcessor.processLexemeDocument(document);
        }
        catch (JsonParseException e1) {
            logger.error("Failed to parse JSON for lexeme " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
        }
        catch (JsonMappingException e1) {
            logger.error("Failed to map JSON for lexeme " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
            e1.printStackTrace();
            System.out.print(mwRevision.getText());
        }
        catch (IOException e1) {
            logger.error("Failed to read revision: " + e1.getMessage());
        }
    }

    private boolean isWikibaseRedirection(MwRevision mwRevision) {
        return mwRevision.getText().contains("\"redirect\":");
    }

    @Override
    public void finishRevisionProcessing() {
    }
}

