/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.wmf;

import java.io.IOException;
import java.io.InputStream;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.util.DirectoryManager;

public class WmfLocalDumpFile
extends WmfDumpFile {
    final DirectoryManager localDumpfileDirectoryManager;
    final DumpContentType dumpContentType;

    public WmfLocalDumpFile(String dateStamp, String projectName, DirectoryManager dumpfileDirectoryManager, DumpContentType dumpContentType) {
        super(dateStamp, projectName);
        String subdirectoryName = WmfDumpFile.getDumpFileDirectoryName(dumpContentType, dateStamp);
        if (!dumpfileDirectoryManager.hasSubdirectory(subdirectoryName)) {
            throw new IllegalArgumentException("There is no local dump file directory at the specified location.");
        }
        try {
            this.localDumpfileDirectoryManager = dumpfileDirectoryManager.getSubdirectoryManager(subdirectoryName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not change to dump file directory", e);
        }
        this.dumpContentType = dumpContentType;
    }

    public String getDumpfileDirectory() {
        return this.localDumpfileDirectoryManager.toString();
    }

    @Override
    public DumpContentType getDumpContentType() {
        return this.dumpContentType;
    }

    @Override
    public InputStream getDumpFileStream() throws IOException {
        String dumpFileName = WmfDumpFile.getDumpFileName(this.dumpContentType, this.projectName, this.dateStamp);
        return this.localDumpfileDirectoryManager.getInputStreamForFile(dumpFileName, WmfDumpFile.getDumpFileCompressionType(dumpFileName));
    }

    @Override
    public void prepareDumpFile() throws IOException {
    }

    @Override
    protected boolean fetchIsDone() {
        return this.localDumpfileDirectoryManager.hasFile(WmfDumpFile.getDumpFileName(this.dumpContentType, this.projectName, this.dateStamp));
    }
}

