/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.wmf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.WebResourceFetcher;

class WmfOnlineDailyDumpFile
extends WmfDumpFile {
    static final Logger logger = LoggerFactory.getLogger(WmfOnlineDailyDumpFile.class);
    final WebResourceFetcher webResourceFetcher;
    final DirectoryManager dumpfileDirectoryManager;
    boolean isPrepared = false;

    public WmfOnlineDailyDumpFile(String dateStamp, String projectName, WebResourceFetcher webResourceFetcher, DirectoryManager dumpfileDirectoryManager) {
        super(dateStamp, projectName);
        this.webResourceFetcher = webResourceFetcher;
        this.dumpfileDirectoryManager = dumpfileDirectoryManager;
    }

    @Override
    public DumpContentType getDumpContentType() {
        return DumpContentType.DAILY;
    }

    @Override
    public InputStream getDumpFileStream() throws IOException {
        this.prepareDumpFile();
        String fileName = WmfDumpFile.getDumpFileName(DumpContentType.DAILY, this.projectName, this.dateStamp);
        DirectoryManager dailyDirectoryManager = this.dumpfileDirectoryManager.getSubdirectoryManager(WmfDumpFile.getDumpFileDirectoryName(DumpContentType.DAILY, this.dateStamp));
        return dailyDirectoryManager.getInputStreamForFile(fileName, WmfDumpFile.getDumpFileCompressionType(fileName));
    }

    @Override
    public void prepareDumpFile() throws IOException {
        long size;
        if (this.isPrepared) {
            return;
        }
        String fileName = WmfDumpFile.getDumpFileName(DumpContentType.DAILY, this.projectName, this.dateStamp);
        String urlString = this.getBaseUrl() + fileName;
        logger.info("Downloading daily dump file " + fileName + " from " + urlString + " ...");
        if (!this.isAvailable()) {
            throw new IOException("Dump file not available (yet). Aborting dump retrieval.");
        }
        DirectoryManager dailyDirectoryManager = this.dumpfileDirectoryManager.getSubdirectoryManager(WmfDumpFile.getDumpFileDirectoryName(DumpContentType.DAILY, this.dateStamp));
        try (InputStream inputStream = this.webResourceFetcher.getInputStreamForUrl(urlString);){
            size = dailyDirectoryManager.createFileAtomic(fileName, inputStream);
        }
        this.isPrepared = true;
        logger.info("... completed download of daily dump file " + fileName + " from " + urlString + " (" + size + " bytes)");
    }

    @Override
    protected boolean fetchIsDone() {
        boolean result;
        try (InputStream in = this.webResourceFetcher.getInputStreamForUrl(this.getBaseUrl() + "status.txt");){
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String inputLine = bufferedReader.readLine();
            bufferedReader.close();
            result = "done".equals(inputLine);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    String getBaseUrl() {
        return WmfDumpFile.getDumpFileWebDirectory(DumpContentType.DAILY, this.projectName) + this.dateStamp + "/";
    }
}

