/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.MwDumpFileProcessor;

public class JsonDumpFileProcessor
implements MwDumpFileProcessor {
    static final Logger logger = LoggerFactory.getLogger(JsonDumpFileProcessor.class);
    private final ObjectReader documentReader;
    private final EntityDocumentProcessor entityDocumentProcessor;

    public JsonDumpFileProcessor(EntityDocumentProcessor entityDocumentProcessor, String siteIri) {
        this.entityDocumentProcessor = entityDocumentProcessor;
        this.documentReader = new DatamodelMapper(siteIri).readerFor(EntityDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
    }

    @Override
    public void processDumpFileContents(InputStream inputStream, MwDumpFile dumpFile) {
        logger.info("Processing JSON dump file " + dumpFile.toString());
        try {
            this.processDumpFileContentsRecovery(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read JSON input: " + e.getMessage(), e);
        }
    }

    private void logJsonProcessingException(JsonProcessingException exception) {
        logger.error("Error when reading JSON for entity: " + exception.getMessage());
    }

    private void handleDocument(EntityDocument document) {
        if (document instanceof ItemDocument) {
            this.entityDocumentProcessor.processItemDocument((ItemDocument)document);
        } else if (document instanceof PropertyDocument) {
            this.entityDocumentProcessor.processPropertyDocument((PropertyDocument)document);
        } else if (document instanceof LexemeDocument) {
            this.entityDocumentProcessor.processLexemeDocument((LexemeDocument)document);
        } else if (document instanceof MediaInfoDocument) {
            this.entityDocumentProcessor.processMediaInfoDocument((MediaInfoDocument)document);
        }
    }

    private void processDumpFileContentsRecovery(InputStream inputStream) throws IOException {
        logger.warn("Entering recovery mode to parse rest of file. This might be slightly slower.");
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        Object line = br.readLine();
        if (line == null) {
            return;
        }
        if (((String)line).length() >= 100) {
            line = ((String)line).substring(0, 100) + "[...]" + ((String)line).substring(((String)line).length() - 50);
        }
        logger.warn("Skipping rest of current line: " + (String)line);
        line = br.readLine();
        while (line != null && ((String)line).length() > 1) {
            try {
                EntityDocument document = ((String)line).charAt(((String)line).length() - 1) == ',' ? (EntityDocument)this.documentReader.readValue(((String)line).substring(0, ((String)line).length() - 1)) : (EntityDocument)this.documentReader.readValue((String)line);
                this.handleDocument(document);
            }
            catch (JsonProcessingException e) {
                this.logJsonProcessingException(e);
                logger.error("Problematic line was: " + ((String)line).substring(0, Math.min(50, ((String)line).length())) + "...");
            }
            line = br.readLine();
        }
    }
}

