/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.util.CompressionType;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.DirectoryManagerFactory;

public class MwLocalDumpFile
implements MwDumpFile {
    static final Logger logger = LoggerFactory.getLogger(MwLocalDumpFile.class);
    final String dateStamp;
    final String projectName;
    final String dumpFileName;
    final Path dumpFilePath;
    final DumpContentType dumpContentType;
    DirectoryManager directoryManager;
    final boolean isAvailable;
    static final Map<DumpContentType, CompressionType> COMPRESSION_TYPE = new HashMap<DumpContentType, CompressionType>();

    public MwLocalDumpFile(String filepath) {
        this(filepath, null, null, null);
    }

    public MwLocalDumpFile(String filePath, DumpContentType dumpContentType, String dateStamp, String projectName) {
        this.dumpFilePath = Paths.get(filePath, new String[0]).toAbsolutePath();
        this.dumpFileName = this.dumpFilePath.getFileName().toString();
        try {
            this.directoryManager = DirectoryManagerFactory.createDirectoryManager((Path)this.dumpFilePath.getParent(), (boolean)true);
        }
        catch (IOException e) {
            this.directoryManager = null;
            logger.error("Could not access local dump file: " + e.toString());
        }
        this.dumpContentType = dumpContentType == null ? MwLocalDumpFile.guessDumpContentType(this.dumpFileName) : dumpContentType;
        this.dateStamp = dateStamp == null ? MwLocalDumpFile.guessDumpDate(this.dumpFileName) : dateStamp;
        this.projectName = projectName == null ? "LOCAL" : projectName;
        this.isAvailable = this.directoryManager != null && this.directoryManager.hasFile(this.dumpFileName);
    }

    public Path getPath() {
        return this.dumpFilePath;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getDateStamp() {
        return this.dateStamp;
    }

    @Override
    public DumpContentType getDumpContentType() {
        return this.dumpContentType;
    }

    @Override
    public InputStream getDumpFileStream() throws IOException {
        if (!this.isAvailable()) {
            throw new IOException("Local dump file \"" + this.dumpFilePath.toString() + "\" is not available for reading.");
        }
        return this.directoryManager.getInputStreamForFile(this.dumpFileName, WmfDumpFile.getDumpFileCompressionType(this.dumpFileName));
    }

    @Override
    public BufferedReader getDumpFileReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getDumpFileStream(), StandardCharsets.UTF_8));
    }

    @Override
    public void prepareDumpFile() {
    }

    public String toString() {
        return this.dumpFilePath.toString() + " (" + this.projectName + "/" + this.getDumpContentType().toString().toLowerCase() + "/" + this.dateStamp + ")";
    }

    private static DumpContentType guessDumpContentType(String fileName) {
        String lcDumpName = fileName.toLowerCase();
        if (lcDumpName.contains(".json.gz")) {
            return DumpContentType.JSON;
        }
        if (lcDumpName.contains(".json.bz2")) {
            return DumpContentType.JSON;
        }
        if (lcDumpName.contains(".sql.gz")) {
            return DumpContentType.SITES;
        }
        if (lcDumpName.contains(".xml.bz2")) {
            if (lcDumpName.contains("daily")) {
                return DumpContentType.DAILY;
            }
            if (lcDumpName.contains("current")) {
                return DumpContentType.CURRENT;
            }
            return DumpContentType.FULL;
        }
        logger.warn("Could not guess type of the dump file \"" + fileName + "\". Defaulting to json.gz.");
        return DumpContentType.JSON;
    }

    private static String guessDumpDate(String fileName) {
        Pattern p = Pattern.compile("([0-9]{8})");
        Matcher m = p.matcher(fileName);
        if (m.find()) {
            return m.group(1);
        }
        logger.info("Could not guess date of the dump file \"" + fileName + "\". Defaulting to YYYYMMDD.");
        return "YYYYMMDD";
    }

    static {
        COMPRESSION_TYPE.put(DumpContentType.DAILY, CompressionType.BZ2);
        COMPRESSION_TYPE.put(DumpContentType.CURRENT, CompressionType.BZ2);
        COMPRESSION_TYPE.put(DumpContentType.FULL, CompressionType.BZ2);
        COMPRESSION_TYPE.put(DumpContentType.SITES, CompressionType.GZIP);
        COMPRESSION_TYPE.put(DumpContentType.JSON, CompressionType.GZIP);
    }
}

