/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.dumpfiles.MwRevision;
import org.wikidata.wdtk.dumpfiles.MwRevisionImpl;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessor;
import org.wikidata.wdtk.storage.datastructures.BitVector;
import org.wikidata.wdtk.storage.datastructures.BitVectorImpl;

public class MwRevisionProcessorBroker
implements MwRevisionProcessor {
    final List<RevisionSubscription> revisionSubscriptions = new ArrayList<RevisionSubscription>();
    MwRevisionImpl mostCurrentRevision = null;
    int currentPageId = -1;
    final BitVector encounteredPages = new BitVectorImpl(20000000L);
    final BitVector encounteredRevisions = new BitVectorImpl(200000000L);

    public void registerMwRevisionProcessor(MwRevisionProcessor mwRevisionProcessor, String model, boolean onlyCurrentRevisions) {
        RevisionSubscription rs = new RevisionSubscription();
        rs.mwRevisionProcessor = mwRevisionProcessor;
        rs.model = model;
        rs.onlyCurrentRevisions = onlyCurrentRevisions;
        this.revisionSubscriptions.add(rs);
    }

    @Override
    public void startRevisionProcessing(String siteName, String baseUrl, Map<Integer, String> namespaces) {
        for (RevisionSubscription rs : this.revisionSubscriptions) {
            rs.mwRevisionProcessor.startRevisionProcessing(siteName, baseUrl, namespaces);
        }
    }

    @Override
    public void processRevision(MwRevision mwRevision) {
        boolean revisionIsNew;
        boolean bl = revisionIsNew = !this.encounteredRevisions.getBit(mwRevision.getRevisionId());
        if (!revisionIsNew) {
            return;
        }
        this.encounteredRevisions.setBit(mwRevision.getRevisionId(), true);
        if (mwRevision.getPageId() != this.currentPageId) {
            boolean currentPageIsNew;
            this.notifyMwRevisionProcessors(this.mostCurrentRevision, true);
            this.currentPageId = mwRevision.getPageId();
            boolean bl2 = currentPageIsNew = !this.encounteredPages.getBit((long)this.currentPageId);
            if (currentPageIsNew) {
                this.encounteredPages.setBit((long)this.currentPageId, true);
                this.mostCurrentRevision = new MwRevisionImpl(mwRevision);
            } else {
                this.mostCurrentRevision = null;
            }
        } else if (this.mostCurrentRevision != null && mwRevision.getRevisionId() > this.mostCurrentRevision.getRevisionId()) {
            this.mostCurrentRevision = new MwRevisionImpl(mwRevision);
        }
        this.notifyMwRevisionProcessors(mwRevision, false);
    }

    void notifyMwRevisionProcessors(MwRevision mwRevision, boolean isCurrent) {
        if (mwRevision == null || mwRevision.getPageId() <= 0) {
            return;
        }
        for (RevisionSubscription rs : this.revisionSubscriptions) {
            if (rs.onlyCurrentRevisions != isCurrent || rs.model != null && !mwRevision.getModel().equals(rs.model)) continue;
            rs.mwRevisionProcessor.processRevision(mwRevision);
        }
    }

    @Override
    public void finishRevisionProcessing() {
        this.notifyMwRevisionProcessors(this.mostCurrentRevision, true);
        this.mostCurrentRevision = null;
        for (RevisionSubscription rs : this.revisionSubscriptions) {
            rs.mwRevisionProcessor.finishRevisionProcessing();
        }
    }

    static class RevisionSubscription {
        MwRevisionProcessor mwRevisionProcessor;
        String model;
        boolean onlyCurrentRevisions;

        RevisionSubscription() {
        }

        public String toString() {
            return "Subscription of " + this.mwRevisionProcessor.getClass().toString() + " to model " + this.model + " (current: " + this.onlyCurrentRevisions + ")";
        }
    }
}

