/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.wmf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.JsonOnlineDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfLocalDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfOnlineDailyDumpFile;
import org.wikidata.wdtk.dumpfiles.wmf.WmfOnlineStandardDumpFile;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.WebResourceFetcher;

public class WmfDumpFileManager {
    static final Logger logger = LoggerFactory.getLogger(WmfDumpFileManager.class);
    static final String DATE_STAMP_PATTERN = "\\d\\d\\d\\d\\d\\d\\d\\d";
    public static final String DOWNLOAD_DIRECTORY_NAME = "dumpfiles";
    final String projectName;
    final DirectoryManager dumpfileDirectoryManager;
    final WebResourceFetcher webResourceFetcher;

    public WmfDumpFileManager(String projectName, DirectoryManager downloadDirectoryManager, WebResourceFetcher webResourceFetcher) throws IOException {
        this.projectName = projectName;
        this.dumpfileDirectoryManager = downloadDirectoryManager.getSubdirectoryManager(DOWNLOAD_DIRECTORY_NAME).getSubdirectoryManager(projectName);
        this.webResourceFetcher = webResourceFetcher;
        logger.info("Using download directory " + this.dumpfileDirectoryManager.toString());
    }

    public List<MwDumpFile> findAllRelevantRevisionDumps(boolean preferCurrent) {
        MwDumpFile mainDump = preferCurrent ? this.findMostRecentDump(DumpContentType.CURRENT) : this.findMostRecentDump(DumpContentType.FULL);
        if (mainDump == null) {
            return this.findAllDumps(DumpContentType.DAILY);
        }
        ArrayList<MwDumpFile> result = new ArrayList<MwDumpFile>();
        for (MwDumpFile dumpFile : this.findAllDumps(DumpContentType.DAILY)) {
            if (dumpFile.getDateStamp().compareTo(mainDump.getDateStamp()) <= 0) continue;
            result.add(dumpFile);
        }
        result.add(mainDump);
        if (logger.isInfoEnabled()) {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("Found ").append(result.size()).append(" relevant dumps to process:");
            for (MwDumpFile dumpFile : result) {
                logMessage.append("\n * ").append(dumpFile.toString());
            }
            logger.info(logMessage.toString());
        }
        return result;
    }

    public MwDumpFile findMostRecentDump(DumpContentType dumpContentType) {
        List<MwDumpFile> dumps = this.findAllDumps(dumpContentType);
        for (MwDumpFile dump : dumps) {
            if (!dump.isAvailable()) continue;
            return dump;
        }
        return null;
    }

    public List<MwDumpFile> findAllDumps(DumpContentType dumpContentType) {
        List<MwDumpFile> localDumps = this.findDumpsLocally(dumpContentType);
        if (this.webResourceFetcher != null) {
            List<MwDumpFile> onlineDumps = this.findDumpsOnline(dumpContentType);
            return this.mergeDumpLists(localDumps, onlineDumps);
        }
        return localDumps;
    }

    List<MwDumpFile> mergeDumpLists(List<MwDumpFile> localDumps, List<MwDumpFile> onlineDumps) {
        ArrayList<MwDumpFile> result = new ArrayList<MwDumpFile>(localDumps);
        HashSet<String> localDateStamps = new HashSet<String>();
        for (MwDumpFile dumpFile : localDumps) {
            localDateStamps.add(dumpFile.getDateStamp());
        }
        for (MwDumpFile dumpFile : onlineDumps) {
            if (localDateStamps.contains(dumpFile.getDateStamp())) continue;
            result.add(dumpFile);
        }
        result.sort(Collections.reverseOrder(new MwDumpFile.DateComparator()));
        return result;
    }

    List<MwDumpFile> findDumpsLocally(DumpContentType dumpContentType) {
        List dumpFileDirectories;
        String directoryPattern = WmfDumpFile.getDumpFileDirectoryName(dumpContentType, "*");
        try {
            dumpFileDirectories = this.dumpfileDirectoryManager.getSubdirectories(directoryPattern);
        }
        catch (IOException e) {
            logger.error("Unable to access dump directory: " + e.toString());
            return Collections.emptyList();
        }
        ArrayList<MwDumpFile> result = new ArrayList<MwDumpFile>();
        for (String directory : dumpFileDirectories) {
            String dateStamp = WmfDumpFile.getDateStampFromDumpFileDirectoryName(dumpContentType, directory);
            if (!dateStamp.matches(DATE_STAMP_PATTERN)) continue;
            WmfLocalDumpFile dumpFile = new WmfLocalDumpFile(dateStamp, this.projectName, this.dumpfileDirectoryManager, dumpContentType);
            if (dumpFile.isAvailable()) {
                result.add(dumpFile);
                continue;
            }
            logger.error("Incomplete local dump file data. Maybe delete " + dumpFile.getDumpfileDirectory() + " to attempt fresh download.");
        }
        result.sort(Collections.reverseOrder(new MwDumpFile.DateComparator()));
        logger.info("Found " + result.size() + " local dumps of type " + String.valueOf((Object)dumpContentType) + ": " + String.valueOf(result));
        return result;
    }

    List<MwDumpFile> findDumpsOnline(DumpContentType dumpContentType) {
        List<String> dumpFileDates = this.findDumpDatesOnline(dumpContentType);
        ArrayList<MwDumpFile> result = new ArrayList<MwDumpFile>();
        for (String dateStamp : dumpFileDates) {
            if (dumpContentType == DumpContentType.DAILY) {
                result.add(new WmfOnlineDailyDumpFile(dateStamp, this.projectName, this.webResourceFetcher, this.dumpfileDirectoryManager));
                continue;
            }
            if (dumpContentType == DumpContentType.JSON) {
                result.add(new JsonOnlineDumpFile(dateStamp, this.projectName, this.webResourceFetcher, this.dumpfileDirectoryManager));
                continue;
            }
            result.add(new WmfOnlineStandardDumpFile(dateStamp, this.projectName, this.webResourceFetcher, this.dumpfileDirectoryManager, dumpContentType));
        }
        logger.info("Found " + result.size() + " online dumps of type " + String.valueOf((Object)dumpContentType) + ": " + String.valueOf(result));
        return result;
    }

    List<String> findDumpDatesOnline(DumpContentType dumpContentType) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream in = this.webResourceFetcher.getInputStreamForUrl(WmfDumpFile.getDumpFileWebDirectory(dumpContentType, this.projectName));){
            String inputLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((inputLine = bufferedReader.readLine()) != null) {
                String dateStamp = "";
                if (inputLine.startsWith("<tr><td class=\"n\">")) {
                    dateStamp = inputLine.substring(27, 35);
                } else if (inputLine.startsWith("<a href=")) {
                    dateStamp = inputLine.substring(9, 17);
                }
                if (!dateStamp.matches(DATE_STAMP_PATTERN)) continue;
                result.add(dateStamp);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            logger.error("Failed to fetch available dump dates online.");
        }
        result.sort(Collections.reverseOrder());
        return result;
    }
}

