/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.wmf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.WebResourceFetcher;

public class WmfOnlineStandardDumpFile
extends WmfDumpFile {
    static final Logger logger = LoggerFactory.getLogger(WmfOnlineStandardDumpFile.class);
    final WebResourceFetcher webResourceFetcher;
    final DirectoryManager dumpfileDirectoryManager;
    final DumpContentType dumpContentType;
    boolean isPrepared = false;

    public WmfOnlineStandardDumpFile(String dateStamp, String projectName, WebResourceFetcher webResourceFetcher, DirectoryManager dumpfileDirectoryManager, DumpContentType dumpContentType) {
        super(dateStamp, projectName);
        this.webResourceFetcher = webResourceFetcher;
        this.dumpfileDirectoryManager = dumpfileDirectoryManager;
        this.dumpContentType = dumpContentType;
    }

    @Override
    public DumpContentType getDumpContentType() {
        return this.dumpContentType;
    }

    @Override
    public InputStream getDumpFileStream() throws IOException {
        this.prepareDumpFile();
        String fileName = WmfDumpFile.getDumpFileName(this.dumpContentType, this.projectName, this.dateStamp);
        DirectoryManager thisDumpDirectoryManager = this.dumpfileDirectoryManager.getSubdirectoryManager(WmfDumpFile.getDumpFileDirectoryName(this.dumpContentType, this.dateStamp));
        return thisDumpDirectoryManager.getInputStreamForFile(fileName, WmfDumpFile.getDumpFileCompressionType(fileName));
    }

    @Override
    public void prepareDumpFile() throws IOException {
        long size;
        if (this.isPrepared) {
            return;
        }
        String fileName = WmfDumpFile.getDumpFileName(this.dumpContentType, this.projectName, this.dateStamp);
        String urlString = this.getBaseUrl() + fileName;
        logger.info("Downloading " + this.dumpContentType.toString().toLowerCase() + " dump file " + fileName + " from " + urlString + " ...");
        if (!this.isAvailable()) {
            throw new IOException("Dump file not available (yet). Aborting dump retrieval.");
        }
        DirectoryManager thisDumpDirectoryManager = this.dumpfileDirectoryManager.getSubdirectoryManager(WmfDumpFile.getDumpFileDirectoryName(this.dumpContentType, this.dateStamp));
        try (InputStream inputStream = this.webResourceFetcher.getInputStreamForUrl(urlString);){
            size = thisDumpDirectoryManager.createFileAtomic(fileName, inputStream);
        }
        this.isPrepared = true;
        logger.info("... completed download of " + this.dumpContentType.toString().toLowerCase() + " dump file " + fileName + " from " + urlString + " (" + size + " bytes)");
    }

    @Override
    protected boolean fetchIsDone() {
        boolean found = false;
        try (InputStream in = this.webResourceFetcher.getInputStreamForUrl(this.getBaseUrl() + this.projectName + "-" + this.dateStamp + "-md5sums.txt");){
            String inputLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String filePostfix = WmfDumpFile.getDumpFilePostfix(this.dumpContentType);
            while (!found && (inputLine = bufferedReader.readLine()) != null) {
                if (!inputLine.endsWith(filePostfix)) continue;
                found = true;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return found;
    }

    String getBaseUrl() {
        return WmfDumpFile.getDumpFileWebDirectory(this.dumpContentType, this.projectName) + this.dateStamp + "/";
    }
}

