/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.WikimediaLanguageCodes;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.ReferenceRdfConverter;
import org.wikidata.wdtk.rdf.SnakRdfConverter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.AnyValueConverter;

public abstract class AbstractRdfConverter {
    static final Logger logger = LoggerFactory.getLogger(AbstractRdfConverter.class);
    final RdfWriter rdfWriter;
    final AnyValueConverter valueRdfConverter;
    final SnakRdfConverter snakRdfConverter;
    final OwlDeclarationBuffer owlDeclarationBuffer = new OwlDeclarationBuffer();
    final ReferenceRdfConverter referenceRdfConverter;
    final PropertyRegister propertyRegister;
    final Sites sites;

    public AbstractRdfConverter(RdfWriter rdfWriter, Sites sites, PropertyRegister propertyRegister) {
        this.sites = sites;
        this.rdfWriter = rdfWriter;
        this.propertyRegister = propertyRegister;
        this.valueRdfConverter = new AnyValueConverter(rdfWriter, this.owlDeclarationBuffer, this.propertyRegister);
        this.snakRdfConverter = new SnakRdfConverter(rdfWriter, this.owlDeclarationBuffer, this.propertyRegister, this.valueRdfConverter);
        this.referenceRdfConverter = new ReferenceRdfConverter(rdfWriter, this.snakRdfConverter, this.propertyRegister.siteUri);
    }

    public void writeBasicDeclarations() throws RDFHandlerException {
        for (Map.Entry<String, String> uriType : Vocabulary.getKnownVocabularyTypes().entrySet()) {
            this.rdfWriter.writeTripleUriObject(uriType.getKey(), RdfWriter.RDF_TYPE, uriType.getValue());
        }
    }

    public void writeNamespaceDeclarations() throws RDFHandlerException {
        this.rdfWriter.writeNamespaceDeclaration("wd", this.propertyRegister.getUriPrefix());
        this.rdfWriter.writeNamespaceDeclaration("wikibase", "http://wikiba.se/ontology#");
        this.rdfWriter.writeNamespaceDeclaration("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.rdfWriter.writeNamespaceDeclaration("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.rdfWriter.writeNamespaceDeclaration("owl", "http://www.w3.org/2002/07/owl#");
        this.rdfWriter.writeNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.rdfWriter.writeNamespaceDeclaration("schema", "http://schema.org/");
        this.rdfWriter.writeNamespaceDeclaration("skos", "http://www.w3.org/2004/02/skos/core#");
        this.rdfWriter.writeNamespaceDeclaration("prov", "http://www.w3.org/ns/prov#");
    }

    public void finishDocument() throws RDFHandlerException {
        this.snakRdfConverter.writeAuxiliaryTriples();
        this.writeOWLDeclarations();
        this.referenceRdfConverter.writeReferences();
    }

    public void writeOWLDeclarations() {
        this.owlDeclarationBuffer.writePropertyDeclarations(this.rdfWriter, true, true);
    }

    public void writeDocumentType(Resource subject, IRI type) {
        this.rdfWriter.writeTripleUriObject(subject, RdfWriter.RDF_TYPE, type.toString());
    }

    public void writeItemDocument(ItemDocument document) throws RDFHandlerException {
        String subjectUri = document.getEntityId().getIri();
        IRI subject = this.rdfWriter.getUri(subjectUri);
        this.writeDocumentType((Resource)subject, RdfWriter.WB_ITEM);
        this.writeDocumentTerms((TermedDocument)document);
        this.writeStatements((StatementDocument)document);
        this.writeSiteLinks((Resource)subject, document.getSiteLinks());
        this.finishDocument();
    }

    public void writePropertyDatatype(PropertyDocument document) {
        this.rdfWriter.writeTripleValueObject((Resource)this.rdfWriter.getUri(document.getEntityId().getIri()), RdfWriter.WB_PROPERTY_TYPE, (Value)this.rdfWriter.getUri(AbstractRdfConverter.getDatatypeIri(document.getDatatype())));
    }

    public void writePropertyDocument(PropertyDocument document) throws RDFHandlerException {
        this.propertyRegister.setPropertyType(document.getEntityId(), AbstractRdfConverter.getDatatypeIri(document.getDatatype()));
        String subjectUri = document.getEntityId().getIri();
        IRI subject = this.rdfWriter.getUri(subjectUri);
        this.writeDocumentType((Resource)subject, RdfWriter.WB_PROPERTY);
        this.writePropertyDatatype(document);
        this.writeDocumentTerms((TermedDocument)document);
        this.writeStatements((StatementDocument)document);
        this.writeInterPropertyLinks(document);
        this.finishDocument();
    }

    public void writeInterPropertyLinks(PropertyDocument document) throws RDFHandlerException {
        IRI subject = this.rdfWriter.getUri(document.getEntityId().getIri());
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#directClaim"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.DIRECT));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#claim"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.STATEMENT));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#statementProperty"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.VALUE_SIMPLE));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#statementValue"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.VALUE));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#qualifier"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.QUALIFIER_SIMPLE));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#qualifierValue"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.QUALIFIER));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#reference"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.REFERENCE_SIMPLE));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#referenceValue"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.REFERENCE));
        this.rdfWriter.writeTripleUriObject((Resource)subject, this.rdfWriter.getUri("http://wikiba.se/ontology#novalue"), Vocabulary.getPropertyUri(document.getEntityId(), PropertyContext.NO_VALUE));
    }

    public void writeDocumentTerms(TermedDocument document) throws RDFHandlerException {
        IRI subject = this.rdfWriter.getUri(document.getEntityId().getIri());
        this.writeTermTriples((Resource)subject, TermKind.LABEL, document.getLabels().values());
        this.writeTermTriples((Resource)subject, TermKind.DESCRIPTION, document.getDescriptions().values());
        for (List aliases : document.getAliases().values()) {
            this.writeTermTriples((Resource)subject, TermKind.ALIAS, aliases);
        }
    }

    public void writeTermTriples(Resource subject, TermKind kind, Collection<MonolingualTextValue> terms) throws RDFHandlerException {
        IRI predicate;
        switch (kind) {
            case LABEL: {
                predicate = RdfWriter.RDFS_LABEL;
                break;
            }
            case DESCRIPTION: {
                predicate = RdfWriter.SCHEMA_DESCRIPTION;
                break;
            }
            case ALIAS: {
                predicate = RdfWriter.SKOS_ALT_LABEL;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (MonolingualTextValue mtv : terms) {
            this.rdfWriter.writeTripleValueObject(subject, predicate, AbstractRdfConverter.getMonolingualTextValueLiteral(mtv, this.rdfWriter));
        }
    }

    public void writeStatements(StatementDocument statementDocument) throws RDFHandlerException {
        for (StatementGroup statementGroup : statementDocument.getStatementGroups()) {
            StatementGroup bestStatements = statementGroup.getBestStatements();
            StatementRank bestRank = statementGroup.getBestStatements() != null ? ((Statement)bestStatements.iterator().next()).getRank() : null;
            Iterator iterator = statementGroup.iterator();
            while (iterator.hasNext()) {
                Statement statement;
                this.writeStatement(statement, (statement = (Statement)iterator.next()).getRank() == bestRank);
            }
        }
    }

    public void writeStatement(Statement statement, boolean best) throws RDFHandlerException {
        if (best) {
            this.writeSimpleStatement(statement);
        }
        this.writeFullStatement(statement, best);
    }

    public void writeFullStatement(Statement statement, boolean best) throws RDFHandlerException {
        IRI subject = this.rdfWriter.getUri(statement.getSubject().getIri());
        String statementUri = Vocabulary.getStatementUri(statement);
        IRI statementResource = this.rdfWriter.getUri(statementUri);
        IRI propertyIri = this.rdfWriter.getUri(Vocabulary.getPropertyUri(statement.getMainSnak().getPropertyId(), PropertyContext.STATEMENT));
        this.rdfWriter.writeTripleUriObject((Resource)subject, propertyIri, statementUri);
        this.rdfWriter.writeTripleValueObject((Resource)statementResource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_STATEMENT);
        this.writeClaim((Resource)statementResource, statement.getClaim());
        this.writeReferences((Resource)statementResource, statement.getReferences());
        this.writeStatementRankTriple((Resource)statementResource, statement.getRank(), best);
    }

    public void writeSimpleStatement(Statement statement) {
        IRI subject = this.rdfWriter.getUri(statement.getSubject().getIri());
        this.snakRdfConverter.setSnakContext((Resource)subject, PropertyContext.DIRECT);
        statement.getMainSnak().accept((SnakVisitor)this.snakRdfConverter);
    }

    public void writeStatementRankTriple(Resource subject, StatementRank rank, boolean best) {
        try {
            this.rdfWriter.writeTripleUriObject(subject, RdfWriter.WB_RANK, Vocabulary.getStatementRankUri(rank));
            if (best) {
                this.rdfWriter.writeTripleUriObject(subject, RdfWriter.RDF_TYPE, "http://wikiba.se/ontology#BestRank");
            }
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void writeReferences(Resource statementResource, List<? extends Reference> references) throws RDFHandlerException {
        for (Reference reference : references) {
            Resource resource = this.referenceRdfConverter.addReference(reference);
            this.rdfWriter.writeTripleValueObject(statementResource, RdfWriter.PROV_WAS_DERIVED_FROM, (Value)resource);
        }
    }

    public void writeClaim(Resource claimResource, Claim claim) {
        this.snakRdfConverter.setSnakContext(claimResource, PropertyContext.VALUE);
        claim.getMainSnak().accept((SnakVisitor)this.snakRdfConverter);
        this.snakRdfConverter.setSnakContext(claimResource, PropertyContext.VALUE_SIMPLE);
        claim.getMainSnak().accept((SnakVisitor)this.snakRdfConverter);
        this.snakRdfConverter.setSnakContext(claimResource, PropertyContext.QUALIFIER);
        for (SnakGroup snakGroup : claim.getQualifiers()) {
            for (Snak snak : snakGroup) {
                snak.accept((SnakVisitor)this.snakRdfConverter);
            }
        }
        this.snakRdfConverter.setSnakContext(claimResource, PropertyContext.QUALIFIER_SIMPLE);
        for (SnakGroup snakGroup : claim.getQualifiers()) {
            for (Snak snak : snakGroup) {
                snak.accept((SnakVisitor)this.snakRdfConverter);
            }
        }
    }

    public void writeSiteLinks(Resource subject, Map<String, SiteLink> siteLinks) throws RDFHandlerException {
        for (String key : siteLinks.keySet()) {
            SiteLink siteLink = siteLinks.get(key);
            String siteLinkUrl = this.sites.getSiteLinkUrl(siteLink);
            if (siteLinkUrl != null) {
                IRI siteLinkUri = this.rdfWriter.getUri(siteLinkUrl);
                this.rdfWriter.writeTripleValueObject((Resource)siteLinkUri, RdfWriter.RDF_TYPE, (Value)RdfWriter.SCHEMA_ARTICLE);
                this.rdfWriter.writeTripleValueObject((Resource)siteLinkUri, RdfWriter.SCHEMA_ABOUT, (Value)subject);
                String siteLanguageCode = this.sites.getLanguageCode(siteLink.getSiteKey());
                this.rdfWriter.writeTripleStringObject((Resource)siteLinkUri, RdfWriter.SCHEMA_IN_LANGUAGE, this.convertSiteLanguageCode(siteLanguageCode));
                for (ItemIdValue badge : siteLink.getBadges()) {
                    this.rdfWriter.writeTripleUriObject((Resource)siteLinkUri, RdfWriter.WB_BADGE, badge.getIri());
                }
                continue;
            }
            logger.warn("Failed to find URL for page \"" + siteLink.getPageTitle() + "\" on site \"" + siteLink.getSiteKey() + "\"");
        }
    }

    private String convertSiteLanguageCode(String languageCode) {
        try {
            return WikimediaLanguageCodes.getLanguageCode((String)languageCode);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unknown Wikimedia language code \"" + languageCode + "\". Using this code in RDF now, but this might be wrong.");
            return languageCode;
        }
    }

    public static Value getMonolingualTextValueLiteral(MonolingualTextValue value, RdfWriter rdfWriter) {
        String languageCode;
        try {
            languageCode = WikimediaLanguageCodes.getLanguageCode((String)value.getLanguageCode());
        }
        catch (IllegalArgumentException e) {
            languageCode = value.getLanguageCode();
            logger.warn("Unknown Wikimedia language code \"" + languageCode + "\". Using this code in RDF now, but this might be wrong.");
        }
        return rdfWriter.getLiteral(value.getText(), languageCode);
    }

    public static String getDatatypeIri(DatatypeIdValue datatype) {
        String jsonDatatype;
        switch (jsonDatatype = datatype.getJsonString()) {
            case "wikibase-item": {
                return "http://wikiba.se/ontology#WikibaseItem";
            }
            case "wikibase-property": {
                return "http://wikiba.se/ontology#WikibaseProperty";
            }
            case "globe-coordinate": {
                return "http://wikiba.se/ontology#GlobeCoordinate";
            }
            case "url": {
                return "http://wikiba.se/ontology#Url";
            }
            case "commonsMedia": {
                return "http://wikiba.se/ontology#CommonsMedia";
            }
            case "time": {
                return "http://wikiba.se/ontology#Time";
            }
            case "quantity": {
                return "http://wikiba.se/ontology#Quantity";
            }
            case "string": {
                return "http://wikiba.se/ontology#String";
            }
            case "monolingualtext": {
                return "http://wikiba.se/ontology#Monolingualtext";
            }
            case "edtf": {
                return "http://wikiba.se/ontology#Edtf";
            }
        }
        Object[] parts = jsonDatatype.split("-");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.capitalize((String)parts[i]);
        }
        return "http://wikiba.se/ontology#" + StringUtils.join((Object[])parts);
    }

    public static enum TermKind {
        LABEL,
        DESCRIPTION,
        ALIAS;

    }
}

