/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;

public class OwlDeclarationBuffer {
    final List<PropertyIdValue> objectPropertyQueue = new ArrayList<PropertyIdValue>();
    final List<PropertyIdValue> datatypePropertyQueue = new ArrayList<PropertyIdValue>();
    final List<IRI> objectPropertyUriQueue = new ArrayList<IRI>();
    final List<IRI> datatypePropertyUriQueue = new ArrayList<IRI>();
    final Set<PropertyIdValue> declaredProperties = new HashSet<PropertyIdValue>();
    final Set<IRI> declaredPropertyUris = new HashSet<IRI>();
    final List<EntityIdValue> classEntityQueue = new ArrayList<EntityIdValue>();
    final Set<EntityIdValue> declaredClassEntities = new HashSet<EntityIdValue>();

    public void addObjectProperty(PropertyIdValue propertyIdValue) {
        if (!this.declaredProperties.contains(propertyIdValue)) {
            this.objectPropertyQueue.add(propertyIdValue);
        }
    }

    public void addObjectProperty(IRI propertyUri) {
        if (!this.declaredPropertyUris.contains(propertyUri)) {
            this.objectPropertyUriQueue.add(propertyUri);
        }
    }

    public void addDatatypeProperty(PropertyIdValue propertyIdValue) {
        if (!this.declaredProperties.contains(propertyIdValue)) {
            this.datatypePropertyQueue.add(propertyIdValue);
        }
    }

    public void addDatatypeProperty(IRI propertyUri) {
        if (!this.declaredPropertyUris.contains(propertyUri)) {
            this.datatypePropertyUriQueue.add(propertyUri);
        }
    }

    public void addClass(EntityIdValue entityIdValue) {
        if (!this.declaredClassEntities.contains(entityIdValue)) {
            this.classEntityQueue.add(entityIdValue);
        }
    }

    public void writePropertyDeclarations(RdfWriter rdfWriter, boolean fullStatements, boolean simpleClaims) throws RDFHandlerException {
        boolean anyStatements = fullStatements || simpleClaims;
        for (PropertyIdValue propertyIdValue : this.objectPropertyQueue) {
            if (!this.declaredProperties.add(propertyIdValue)) continue;
            if (anyStatements) {
                this.writeNoValueRestriction(rdfWriter, propertyIdValue.getIri(), "http://www.w3.org/2002/07/owl#Thing", Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.NO_VALUE));
            }
            if (fullStatements) {
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.STATEMENT), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.VALUE_SIMPLE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.VALUE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.QUALIFIER), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.REFERENCE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.QUALIFIER_SIMPLE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.REFERENCE_SIMPLE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
            }
            if (!simpleClaims) continue;
            rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.DIRECT), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
        }
        this.objectPropertyQueue.clear();
        for (PropertyIdValue propertyIdValue : this.datatypePropertyQueue) {
            if (!this.declaredProperties.add(propertyIdValue)) continue;
            if (anyStatements) {
                this.writeNoValueRestriction(rdfWriter, propertyIdValue.getIri(), "http://www.w3.org/2001/XMLSchema#string", Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.NO_VALUE));
            }
            if (fullStatements) {
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.STATEMENT), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.VALUE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.QUALIFIER), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.REFERENCE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.VALUE_SIMPLE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.QUALIFIER_SIMPLE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.REFERENCE_SIMPLE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
            }
            if (!simpleClaims) continue;
            rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.DIRECT), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
        }
        this.datatypePropertyQueue.clear();
        for (IRI propertyUri : this.objectPropertyUriQueue) {
            if (!this.declaredPropertyUris.add(propertyUri)) continue;
            rdfWriter.writeTripleValueObject((Resource)propertyUri, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
        }
        this.objectPropertyUriQueue.clear();
        for (IRI propertyUri : this.datatypePropertyUriQueue) {
            if (!this.declaredPropertyUris.add(propertyUri)) continue;
            rdfWriter.writeTripleValueObject((Resource)propertyUri, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
        }
        this.datatypePropertyUriQueue.clear();
    }

    void writeNoValueRestriction(RdfWriter rdfWriter, String propertyUri, String rangeUri, String subject) throws RDFHandlerException {
        BNode bnodeSome = rdfWriter.getFreshBNode();
        rdfWriter.writeTripleValueObject(subject, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_CLASS);
        rdfWriter.writeTripleValueObject(subject, RdfWriter.OWL_COMPLEMENT_OF, (Value)bnodeSome);
        rdfWriter.writeTripleValueObject((Resource)bnodeSome, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_RESTRICTION);
        rdfWriter.writeTripleUriObject((Resource)bnodeSome, RdfWriter.OWL_ON_PROPERTY, propertyUri);
        rdfWriter.writeTripleUriObject((Resource)bnodeSome, RdfWriter.OWL_SOME_VALUES_FROM, rangeUri);
    }
}

