/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.implementation.EntityIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.rdf.AbstractRdfConverter;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.BasicApiConnection;
import org.wikidata.wdtk.wikibaseapi.WikibaseDataFetcher;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class PropertyRegister {
    static final Logger logger = LoggerFactory.getLogger(PropertyRegister.class);
    WikibaseDataFetcher dataFetcher;
    protected final Map<String, String> datatypes = new HashMap<String, String>();
    protected final Map<String, String> uriPatterns = new HashMap<String, String>();
    final String uriPatternPropertyId;
    final String siteUri;
    final int API_MAX_ENTITY_DOCUMENT_NUMBER = 50;
    int smallestUnfetchedPropertyIdNumber = 1;
    final Set<String> knownMissing;
    static final PropertyRegister WIKIDATA_PROPERTY_REGISTER = new PropertyRegister("P1921", (ApiConnection)BasicApiConnection.getWikidataApiConnection(), "http://www.wikidata.org/entity/");

    public PropertyRegister(String uriPatternPropertyId, ApiConnection apiConnection, String siteUri) {
        this.uriPatternPropertyId = uriPatternPropertyId;
        this.siteUri = siteUri;
        this.knownMissing = new HashSet<String>();
        this.dataFetcher = new WikibaseDataFetcher(apiConnection, siteUri);
    }

    public static PropertyRegister getWikidataPropertyRegister() {
        return WIKIDATA_PROPERTY_REGISTER;
    }

    public String getUriPrefix() {
        return this.siteUri;
    }

    public String getPropertyType(PropertyIdValue propertyIdValue) {
        if (!this.datatypes.containsKey(propertyIdValue.getId())) {
            this.fetchPropertyInformation(propertyIdValue);
        }
        return this.datatypes.get(propertyIdValue.getId());
    }

    public void setPropertyType(PropertyIdValue propertyIdValue, String datatypeIri) {
        this.datatypes.put(propertyIdValue.getId(), datatypeIri);
    }

    public String getPropertyUriPattern(PropertyIdValue propertyIdValue) {
        if (!this.datatypes.containsKey(propertyIdValue.getId())) {
            this.fetchPropertyInformation(propertyIdValue);
        }
        return this.uriPatterns.get(propertyIdValue.getId());
    }

    public String setPropertyTypeFromEntityIdValue(PropertyIdValue propertyIdValue, EntityIdValue value) {
        try {
            return EntityIdValueImpl.guessEntityTypeFromId((String)value.getId());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Could not determine datatype of " + propertyIdValue.getId() + ".");
            logger.warn("Example value " + value.getId() + " is not recognized as a valid entity id.");
            logger.warn("Perhaps this is a newly introduced datatype not supported by this version of wdtk.");
            logger.warn("Consider upgrading the library to a newer version.");
            return null;
        }
    }

    public String setPropertyTypeFromGlobeCoordinatesValue(PropertyIdValue propertyIdValue, GlobeCoordinatesValue value) {
        return "http://wikiba.se/ontology#GlobeCoordinate";
    }

    public String setPropertyTypeFromQuantityValue(PropertyIdValue propertyIdValue, QuantityValue value) {
        return "http://wikiba.se/ontology#Quantity";
    }

    public String setPropertyTypeFromStringValue(PropertyIdValue propertyIdValue, StringValue value) {
        String datatype = this.getPropertyType(propertyIdValue);
        if (datatype == null) {
            logger.warn("Could not fetch datatype of " + propertyIdValue.getIri() + ". Assuming type http://wikiba.se/ontology#String");
            return "http://wikiba.se/ontology#String";
        }
        return datatype;
    }

    public String setPropertyTypeFromTimeValue(PropertyIdValue propertyIdValue, TimeValue value) {
        return "http://wikiba.se/ontology#Time";
    }

    public String setPropertyTypeFromMonolingualTextValue(PropertyIdValue propertyIdValue, MonolingualTextValue value) {
        return "http://wikiba.se/ontology#Monolingualtext";
    }

    protected void fetchPropertyInformation(PropertyIdValue property) {
        Map properties;
        int propertyIdNumber = Integer.parseInt(property.getId().substring(1));
        if (this.smallestUnfetchedPropertyIdNumber > propertyIdNumber || this.knownMissing.contains(property.getId())) {
            return;
        }
        ArrayList<Object> propertyIds = new ArrayList<Object>(50);
        propertyIds.add(property.getId());
        for (int i = 1; i < 50; ++i) {
            propertyIds.add("P" + this.smallestUnfetchedPropertyIdNumber);
            ++this.smallestUnfetchedPropertyIdNumber;
        }
        this.dataFetcher.getFilter().setLanguageFilter(Collections.emptySet());
        this.dataFetcher.getFilter().setSiteLinkFilter(Collections.emptySet());
        try {
            properties = this.dataFetcher.getEntityDocuments(propertyIds);
        }
        catch (IOException | MediaWikiApiErrorException e) {
            logger.error("Error when trying to fetch property data: " + e.toString());
            properties = Collections.emptyMap();
        }
        for (Map.Entry entry : properties.entrySet()) {
            EntityDocument propertyDocument = (EntityDocument)entry.getValue();
            if (!(propertyDocument instanceof PropertyDocument)) continue;
            String datatype = AbstractRdfConverter.getDatatypeIri(((PropertyDocument)propertyDocument).getDatatype());
            this.datatypes.put((String)entry.getKey(), datatype);
            logger.info("Fetched type information for property " + (String)entry.getKey() + " online: " + datatype);
            if (!"http://wikiba.se/ontology#String".equals(datatype) && !"http://wikiba.se/ontology#ExternalId".equals(datatype)) continue;
            for (StatementGroup sg : ((PropertyDocument)propertyDocument).getStatementGroups()) {
                if (!sg.getProperty().getId().equals(this.uriPatternPropertyId)) continue;
                for (Statement statement : sg) {
                    if (!(statement.getMainSnak() instanceof ValueSnak) || !(statement.getValue() instanceof StringValue)) continue;
                    String uriPattern = ((StringValue)statement.getValue()).getString();
                    if (this.uriPatterns.containsKey(entry.getKey())) {
                        logger.info("Found multiple URI patterns for property " + (String)entry.getKey() + " but only one is supported in current code.");
                    }
                    this.uriPatterns.put((String)entry.getKey(), uriPattern);
                }
            }
        }
        if (!this.datatypes.containsKey(property.getId())) {
            logger.error("Failed to fetch type information for property " + property.getId() + " online.");
            this.knownMissing.add(property.getId());
        }
    }

    public void fetchUsingSPARQL(URI endpoint) {
        try {
            String query = "SELECT ?prop ?type ?uri WHERE { <" + this.siteUri + this.uriPatternPropertyId + "> <http://wikiba.se/ontology#directClaim> ?uriDirect . ?prop <http://wikiba.se/ontology#propertyType> ?type . OPTIONAL { ?prop ?uriDirect ?uri } }";
            String queryString = "query=" + query + "&format=json";
            URL queryUrl = new URI(endpoint.getScheme(), endpoint.getUserInfo(), endpoint.getHost(), endpoint.getPort(), endpoint.getPath(), queryString, null).toURL();
            HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Wikidata-Toolkit PropertyRegister");
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(connection.getInputStream());
            JsonNode bindings = root.path("results").path("bindings");
            SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
            int count = 0;
            int countPatterns = 0;
            for (JsonNode binding : bindings) {
                IRI property = valueFactory.createIRI(binding.path("prop").path("value").asText());
                IRI propType = valueFactory.createIRI(binding.path("type").path("value").asText());
                PropertyIdValueImpl propId = new PropertyIdValueImpl(property.getLocalName(), this.siteUri);
                this.setPropertyType((PropertyIdValue)propId, propType.toString());
                ++count;
                if (!binding.has("uri")) continue;
                ++countPatterns;
                this.uriPatterns.put(propId.getId(), binding.path("uri").path("value").asText());
            }
            logger.info("Fetched type information for " + count + " properties (" + countPatterns + " with URI patterns) using SPARQL.");
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Error when trying to fetch property data using SPARQL: " + e.toString());
        }
    }
}

