/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.Collection;
import java.util.Map;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.rdf.AbstractRdfConverter;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;

public class RdfConverter
extends AbstractRdfConverter {
    int tasks = 1015;

    public RdfConverter(RdfWriter rdfWriter, Sites sites, PropertyRegister propertyRegister) {
        super(rdfWriter, sites, propertyRegister);
    }

    public void setTasks(int tasks) {
        this.tasks = tasks;
    }

    public int getTasks() {
        return this.tasks;
    }

    boolean hasTask(int task) {
        return (this.tasks & task) == task;
    }

    @Override
    public void writeTermTriples(Resource subject, AbstractRdfConverter.TermKind kind, Collection<MonolingualTextValue> terms) throws RDFHandlerException {
        switch (kind) {
            case LABEL: {
                if (this.hasTask(16)) break;
                return;
            }
            case DESCRIPTION: {
                if (this.hasTask(32)) break;
                return;
            }
            case ALIAS: {
                if (this.hasTask(64)) break;
                return;
            }
        }
        super.writeTermTriples(subject, kind, terms);
    }

    @Override
    public void writeSiteLinks(Resource subject, Map<String, SiteLink> siteLinks) throws RDFHandlerException {
        if (!this.hasTask(2)) {
            return;
        }
        super.writeSiteLinks(subject, siteLinks);
    }

    @Override
    public void writePropertyDatatype(PropertyDocument document) {
        if (!this.hasTask(4)) {
            return;
        }
        super.writePropertyDatatype(document);
    }

    @Override
    public void writeInterPropertyLinks(PropertyDocument document) throws RDFHandlerException {
        if (!this.hasTask(128)) {
            return;
        }
        super.writeInterPropertyLinks(document);
    }

    @Override
    public void writeSimpleStatement(Statement statement) {
        if (!this.hasTask(262144)) {
            return;
        }
        if (statement.getQualifiers().size() == 0) {
            super.writeSimpleStatement(statement);
        }
    }

    @Override
    public void writeFullStatement(Statement statement, boolean best) throws RDFHandlerException {
        if (!this.hasTask(1)) {
            return;
        }
        super.writeFullStatement(statement, best);
    }

    @Override
    public void writeItemDocument(ItemDocument document) throws RDFHandlerException {
        if (!this.hasTask(256)) {
            return;
        }
        super.writeItemDocument(document);
    }

    @Override
    public void writePropertyDocument(PropertyDocument document) throws RDFHandlerException {
        if (!this.hasTask(512)) {
            return;
        }
        super.writePropertyDocument(document);
    }

    @Override
    public void writeOWLDeclarations() {
        this.owlDeclarationBuffer.writePropertyDeclarations(this.rdfWriter, this.hasTask(1), this.hasTask(262144));
    }
}

