/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.io.OutputStream;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class RdfWriter {
    static final ValueFactory factory = SimpleValueFactory.getInstance();
    public static final IRI RDF_TYPE = factory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    public static final IRI RDFS_LABEL = factory.createIRI("http://www.w3.org/2000/01/rdf-schema#label");
    public static final IRI RDFS_SEE_ALSO = factory.createIRI("http://www.w3.org/2000/01/rdf-schema#seeAlso");
    public static final IRI RDFS_LITERAL = factory.createIRI("http://www.w3.org/2000/01/rdf-schema#Literal");
    public static final IRI RDFS_SUBCLASS_OF = factory.createIRI("http://www.w3.org/2000/01/rdf-schema#subClassOf");
    public static final IRI RDFS_SUBPROPERTY_OF = factory.createIRI("http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
    public static final IRI OWL_THING = factory.createIRI("http://www.w3.org/2002/07/owl#Thing");
    public static final IRI OWL_CLASS = factory.createIRI("http://www.w3.org/2002/07/owl#Class");
    public static final IRI OWL_OBJECT_PROPERTY = factory.createIRI("http://www.w3.org/2002/07/owl#ObjectProperty");
    public static final IRI OWL_DATATYPE_PROPERTY = factory.createIRI("http://www.w3.org/2002/07/owl#DatatypeProperty");
    public static final IRI OWL_RESTRICTION = factory.createIRI("http://www.w3.org/2002/07/owl#Restriction");
    public static final IRI OWL_SOME_VALUES_FROM = factory.createIRI("http://www.w3.org/2002/07/owl#someValuesFrom");
    public static final IRI OWL_ON_PROPERTY = factory.createIRI("http://www.w3.org/2002/07/owl#onProperty");
    public static final IRI OWL_COMPLEMENT_OF = factory.createIRI("http://www.w3.org/2002/07/owl#complementOf");
    public static final IRI XSD_DOUBLE = factory.createIRI("http://www.w3.org/2001/XMLSchema#double");
    public static final IRI XSD_DECIMAL = factory.createIRI("http://www.w3.org/2001/XMLSchema#decimal");
    public static final IRI XSD_INT = factory.createIRI("http://www.w3.org/2001/XMLSchema#int");
    public static final IRI XSD_DATE = factory.createIRI("http://www.w3.org/2001/XMLSchema#date");
    public static final IRI XSD_G_YEAR = factory.createIRI("http://www.w3.org/2001/XMLSchema#gYear");
    public static final IRI XSD_G_YEAR_MONTH = factory.createIRI("http://www.w3.org/2001/XMLSchema#gYearMonth");
    public static final IRI XSD_DATETIME = factory.createIRI("http://www.w3.org/2001/XMLSchema#dateTime");
    public static final IRI XSD_STRING = factory.createIRI("http://www.w3.org/2001/XMLSchema#string");
    public static final IRI SKOS_ALT_LABEL = factory.createIRI("http://www.w3.org/2004/02/skos/core#altLabel");
    public static final IRI SCHEMA_ABOUT = factory.createIRI("http://schema.org/about");
    public static final IRI SCHEMA_ARTICLE = factory.createIRI("http://schema.org/Article");
    public static final IRI SCHEMA_DESCRIPTION = factory.createIRI("http://schema.org/description");
    public static final IRI SCHEMA_IN_LANGUAGE = factory.createIRI("http://schema.org/inLanguage");
    public static final IRI PROV_WAS_DERIVED_FROM = factory.createIRI("http://www.w3.org/ns/prov#wasDerivedFrom");
    public static final IRI WB_ITEM = factory.createIRI("http://wikiba.se/ontology#Item");
    public static final IRI WB_REFERENCE = factory.createIRI("http://wikiba.se/ontology#Reference");
    public static final IRI WB_PROPERTY = factory.createIRI("http://wikiba.se/ontology#Property");
    public static final IRI WB_STATEMENT = factory.createIRI("http://wikiba.se/ontology#Statement");
    public static final IRI WB_QUANTITY_VALUE = factory.createIRI("http://wikiba.se/ontology#QuantityValue");
    public static final IRI WB_TIME_VALUE = factory.createIRI("http://wikiba.se/ontology#TimeValue");
    public static final IRI WB_GLOBE_COORDINATES_VALUE = factory.createIRI("http://wikiba.se/ontology#GlobecoordinateValue");
    public static final IRI WB_PROPERTY_TYPE = factory.createIRI("http://wikiba.se/ontology#propertyType");
    public static final IRI WB_GEO_GLOBE = factory.createIRI("http://wikiba.se/ontology#geoGlobe");
    public static final IRI WB_GEO_LATITUDE = factory.createIRI("http://wikiba.se/ontology#geoLatitude");
    public static final IRI WB_GEO_LONGITUDE = factory.createIRI("http://wikiba.se/ontology#geoLongitude");
    public static final IRI WB_GEO_PRECISION = factory.createIRI("http://wikiba.se/ontology#geoPrecision");
    public static final IRI WB_TIME = factory.createIRI("http://wikiba.se/ontology#timeValue");
    public static final IRI WB_TIME_PRECISION = factory.createIRI("http://wikiba.se/ontology#timePrecision");
    public static final IRI WB_TIME_TIMEZONE = factory.createIRI("http://wikiba.se/ontology#timeTimezone");
    public static final IRI WB_TIME_CALENDAR_MODEL = factory.createIRI("http://wikiba.se/ontology#timeCalendarModel");
    public static final IRI WB_QUANTITY_AMOUNT = factory.createIRI("http://wikiba.se/ontology#quantityAmount");
    public static final IRI WB_QUANTITY_LOWER_BOUND = factory.createIRI("http://wikiba.se/ontology#quantityLowerBound");
    public static final IRI WB_QUANTITY_UPPER_BOUND = factory.createIRI("http://wikiba.se/ontology#quantityUpperBound");
    public static final IRI WB_QUANTITY_UNIT = factory.createIRI("http://wikiba.se/ontology#quantityUnit");
    public static final IRI OGC_LOCATION = factory.createIRI("http://www.opengis.net/ont/geosparql#wktLiteral");
    public static final IRI WB_RANK = factory.createIRI("http://wikiba.se/ontology#rank");
    public static final IRI WB_BEST_RANK = factory.createIRI("http://wikiba.se/ontology#BestRank");
    public static final IRI WB_BADGE = factory.createIRI("http://wikiba.se/ontology#badge");
    RDFWriter writer;
    long tripleCount = 0L;

    public RdfWriter(RDFFormat format, OutputStream output) throws UnsupportedRDFormatException {
        this(Rio.createWriter((RDFFormat)format, (OutputStream)output));
    }

    public RdfWriter(RDFWriter writer) {
        this.writer = writer;
    }

    public long getTripleCount() {
        return this.tripleCount;
    }

    public void start() throws RDFHandlerException {
        this.tripleCount = 0L;
        this.writer.startRDF();
    }

    public void finish() throws RDFHandlerException {
        this.writer.endRDF();
    }

    public BNode getFreshBNode() {
        return factory.createBNode();
    }

    public IRI getUri(String uri) {
        return factory.createIRI(uri);
    }

    public Literal getLiteral(String value) {
        return factory.createLiteral(value);
    }

    public Literal getLiteral(String value, String languageCode) {
        return factory.createLiteral(value, languageCode);
    }

    public Literal getLiteral(String value, IRI datatypeUri) {
        return factory.createLiteral(value, datatypeUri);
    }

    public void writeNamespaceDeclaration(String prefix, String uri) throws RDFHandlerException {
        this.writer.handleNamespace(prefix, uri);
    }

    public void writeTripleStringObject(Resource subject, IRI predicate, String objectLiteral) throws RDFHandlerException {
        this.writeTripleValueObject(subject, predicate, (Value)factory.createLiteral(objectLiteral));
    }

    public void writeTripleIntegerObject(Resource subject, IRI predicate, int objectLiteral) throws RDFHandlerException {
        this.writeTripleValueObject(subject, predicate, (Value)factory.createLiteral(objectLiteral));
    }

    public void writeTripleUriObject(String subjectUri, IRI predicate, String objectUri) throws RDFHandlerException {
        this.writeTripleValueObject(subjectUri, predicate, (Value)factory.createIRI(objectUri));
    }

    public void writeTripleUriObject(Resource subject, IRI predicate, String objectUri) throws RDFHandlerException {
        this.writeTripleValueObject(subject, predicate, (Value)factory.createIRI(objectUri));
    }

    public void writeTripleValueObject(String subjectUri, IRI predicate, Value object) throws RDFHandlerException {
        IRI subject = factory.createIRI(subjectUri);
        ++this.tripleCount;
        this.writer.handleStatement(factory.createStatement((Resource)subject, predicate, object));
    }

    public void writeTripleValueObject(Resource subject, IRI predicate, Value object) throws RDFHandlerException {
        ++this.tripleCount;
        this.writer.handleStatement(factory.createStatement(subject, predicate, object));
    }

    public void writeTripleLiteralObject(Resource subject, IRI predicate, String objectLexicalValue, IRI datatype) throws RDFHandlerException {
        Literal object = factory.createLiteral(objectLexicalValue, datatype);
        ++this.tripleCount;
        this.writer.handleStatement(factory.createStatement(subject, predicate, (Value)object));
    }
}

