/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.SnakRdfConverter;
import org.wikidata.wdtk.rdf.Vocabulary;

public class ReferenceRdfConverter {
    final RdfWriter rdfWriter;
    final SnakRdfConverter snakRdfConverter;
    final List<Reference> referenceQueue = new ArrayList<Reference>();
    final List<Resource> referenceSubjectQueue = new ArrayList<Resource>();
    final Set<Resource> declaredReferences = new HashSet<Resource>();
    final String siteUri;

    public ReferenceRdfConverter(RdfWriter rdfWriter, SnakRdfConverter snakRdfConverter, String siteUri) {
        this.rdfWriter = rdfWriter;
        this.snakRdfConverter = snakRdfConverter;
        this.siteUri = siteUri;
    }

    public Resource addReference(Reference reference) {
        IRI resource = this.rdfWriter.getUri(Vocabulary.getReferenceUri(reference));
        this.referenceQueue.add(reference);
        this.referenceSubjectQueue.add((Resource)resource);
        return resource;
    }

    public void writeReferences() throws RDFHandlerException {
        Iterator<Reference> referenceIterator = this.referenceQueue.iterator();
        for (Resource resource : this.referenceSubjectQueue) {
            Reference reference = referenceIterator.next();
            if (!this.declaredReferences.add(resource)) continue;
            this.writeReference(reference, resource);
        }
        this.referenceSubjectQueue.clear();
        this.referenceQueue.clear();
        this.snakRdfConverter.writeAuxiliaryTriples();
    }

    void writeReference(Reference reference, Resource resource) throws RDFHandlerException {
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_REFERENCE);
        for (SnakGroup snakGroup : reference.getSnakGroups()) {
            this.snakRdfConverter.setSnakContext(resource, PropertyContext.REFERENCE);
            for (Snak snak : snakGroup) {
                snak.accept((SnakVisitor)this.snakRdfConverter);
            }
            this.snakRdfConverter.setSnakContext(resource, PropertyContext.REFERENCE_SIMPLE);
            for (Snak snak : snakGroup) {
                snak.accept((SnakVisitor)this.snakRdfConverter);
            }
        }
    }
}

