/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.AnyValueConverter;

public class SnakRdfConverter
implements SnakVisitor<Void> {
    static final Logger logger = LoggerFactory.getLogger(SnakRdfConverter.class);
    final AnyValueConverter valueRdfConverter;
    final RdfWriter rdfWriter;
    final PropertyRegister propertyRegister;
    final OwlDeclarationBuffer rdfConversionBuffer;
    final List<PropertyRestriction> someValuesQueue;
    Resource currentSubject;
    PropertyContext currentPropertyContext;
    boolean simple;

    public SnakRdfConverter(RdfWriter rdfWriter, OwlDeclarationBuffer owlDeclarationBuffer, PropertyRegister propertyRegister, AnyValueConverter valueRdfConverter) {
        this.rdfWriter = rdfWriter;
        this.rdfConversionBuffer = owlDeclarationBuffer;
        this.propertyRegister = propertyRegister;
        this.valueRdfConverter = valueRdfConverter;
        this.someValuesQueue = new ArrayList<PropertyRestriction>();
    }

    public void writeSnak(Snak snak, Resource subject, PropertyContext propertyContext) {
        this.setSnakContext(subject, propertyContext);
        snak.accept((SnakVisitor)this);
    }

    public void setSnakContext(Resource subject, PropertyContext propertyContext) {
        this.currentSubject = subject;
        this.currentPropertyContext = propertyContext;
        this.simple = this.currentPropertyContext == PropertyContext.DIRECT || this.currentPropertyContext == PropertyContext.VALUE_SIMPLE || this.currentPropertyContext == PropertyContext.QUALIFIER_SIMPLE || this.currentPropertyContext == PropertyContext.REFERENCE_SIMPLE;
    }

    public Void visit(ValueSnak snak) {
        String propertyUri = Vocabulary.getPropertyUri(snak.getPropertyId(), this.currentPropertyContext);
        IRI property = this.rdfWriter.getUri(propertyUri);
        Value value = this.valueRdfConverter.getRdfValue(snak.getValue(), snak.getPropertyId(), this.simple);
        if (value == null) {
            return null;
        }
        try {
            this.rdfWriter.writeTripleValueObject(this.currentSubject, property, value);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return null;
    }

    public Void visit(SomeValueSnak snak) {
        String rangeUri = this.getRangeUri(snak.getPropertyId());
        if (rangeUri == null) {
            logger.error("Count not export SomeValueSnak for property " + snak.getPropertyId().getId() + ": OWL range not known.");
            return null;
        }
        if (this.currentPropertyContext == PropertyContext.VALUE || this.currentPropertyContext == PropertyContext.QUALIFIER || this.currentPropertyContext == PropertyContext.REFERENCE) {
            return null;
        }
        String propertyUri = Vocabulary.getPropertyUri(snak.getPropertyId(), this.currentPropertyContext);
        BNode bnode = this.rdfWriter.getFreshBNode();
        try {
            this.rdfWriter.writeTripleValueObject(this.currentSubject, this.rdfWriter.getUri(propertyUri), (Value)bnode);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return null;
    }

    public Void visit(NoValueSnak snak) {
        if (this.simple) {
            if (this.getRangeUri(snak.getPropertyId()) == null) {
                logger.error("Count not export NoValueSnak for property " + snak.getPropertyId().getId() + ": OWL range not known.");
                return null;
            }
            String noValueClass = this.currentPropertyContext == PropertyContext.QUALIFIER || this.currentPropertyContext == PropertyContext.QUALIFIER_SIMPLE ? Vocabulary.getPropertyUri(snak.getPropertyId(), PropertyContext.NO_QUALIFIER_VALUE) : Vocabulary.getPropertyUri(snak.getPropertyId(), PropertyContext.NO_VALUE);
            try {
                this.rdfWriter.writeTripleUriObject(this.currentSubject, RdfWriter.RDF_TYPE, noValueClass);
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
        return null;
    }

    public void writeAuxiliaryTriples() throws RDFHandlerException {
        for (PropertyRestriction pr : this.someValuesQueue) {
            this.writeSomeValueRestriction(pr.propertyUri, pr.rangeUri, pr.subject);
        }
        this.someValuesQueue.clear();
        this.valueRdfConverter.writeAuxiliaryTriples();
    }

    void writeSomeValueRestriction(String propertyUri, String rangeUri, Resource bnode) throws RDFHandlerException {
        this.rdfWriter.writeTripleValueObject(bnode, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_RESTRICTION);
        this.rdfWriter.writeTripleUriObject(bnode, RdfWriter.OWL_ON_PROPERTY, propertyUri);
        this.rdfWriter.writeTripleUriObject(bnode, RdfWriter.OWL_SOME_VALUES_FROM, rangeUri);
    }

    String getRangeUri(PropertyIdValue propertyIdValue) {
        String datatype = this.propertyRegister.getPropertyType(propertyIdValue);
        if (datatype == null) {
            return null;
        }
        switch (datatype) {
            case "http://wikiba.se/ontology#Monolingualtext": {
                this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                return "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
            }
            case "http://wikiba.se/ontology#String": 
            case "http://wikiba.se/ontology#ExternalId": 
            case "http://wikiba.se/ontology#Math": {
                this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                return "http://www.w3.org/2001/XMLSchema#string";
            }
            case "http://wikiba.se/ontology#CommonsMedia": 
            case "http://wikiba.se/ontology#GlobeCoordinate": 
            case "http://wikiba.se/ontology#WikibaseItem": 
            case "http://wikiba.se/ontology#WikibaseProperty": 
            case "http://wikiba.se/ontology#WikibaseLexeme": 
            case "http://wikiba.se/ontology#WikibaseForm": 
            case "http://wikiba.se/ontology#WikibaseSense": 
            case "http://wikiba.se/ontology#Time": 
            case "http://wikiba.se/ontology#Url": 
            case "http://wikiba.se/ontology#GeoShape": 
            case "http://wikiba.se/ontology#TabularData": 
            case "http://wikiba.se/ontology#Quantity": {
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                return "http://www.w3.org/2002/07/owl#Thing";
            }
        }
        return null;
    }

    void addSomeValuesRestriction(Resource subject, String propertyUri, String rangeUri) {
        this.someValuesQueue.add(new PropertyRestriction(subject, propertyUri, rangeUri));
    }

    private static class PropertyRestriction {
        final Resource subject;
        final String propertyUri;
        final String rangeUri;

        PropertyRestriction(Resource subject, String propertyUri, String rangeUri) {
            this.subject = subject;
            this.propertyUri = propertyUri;
            this.rangeUri = rangeUri;
        }
    }
}

