/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.wikibaseapi.GuidGenerator;
import org.wikidata.wdtk.wikibaseapi.RandomGuidGenerator;

public class Vocabulary {
    static final MessageDigest md;
    private static final GuidGenerator GUID_GENERATOR;
    public static final String PREFIX_WIKIDATA_STATEMENT = "http://www.wikidata.org/entity/statement/";
    public static final String PREFIX_PROPERTY = "http://www.wikidata.org/prop/";
    public static final String PREFIX_PROPERTY_STATEMENT = "http://www.wikidata.org/prop/statement/";
    public static final String PREFIX_PROPERTY_STATEMENT_VALUE = "http://www.wikidata.org/prop/statement/value/";
    public static final String PREFIX_PROPERTY_DIRECT = "http://www.wikidata.org/prop/direct/";
    public static final String PREFIX_PROPERTY_QUALIFIER = "http://www.wikidata.org/prop/qualifier/";
    public static final String PREFIX_PROPERTY_QUALIFIER_VALUE = "http://www.wikidata.org/prop/qualifier/value/";
    public static final String PREFIX_PROPERTY_REFERENCE = "http://www.wikidata.org/prop/reference/";
    public static final String PREFIX_PROPERTY_REFERENCE_VALUE = "http://www.wikidata.org/prop/reference/value/";
    public static final String PREFIX_GEO = "http://www.opengis.net/ont/geosparql#";
    public static final String PREFIX_WIKIDATA_REFERENCE = "http://www.wikidata.org/reference/";
    public static final String PREFIX_WIKIDATA_NO_VALUE = "http://www.wikidata.org/prop/novalue/";
    public static final String PREFIX_WIKIDATA_NO_QUALIFIER_VALUE = "http://www.wikidata.org/prop/novalue/";
    public static final String PREFIX_WIKIDATA_VALUE = "http://www.wikidata.org/value/";
    public static final String PREFIX_WBONTO = "http://wikiba.se/ontology#";
    public static final String PREFIX_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String PREFIX_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String PREFIX_OWL = "http://www.w3.org/2002/07/owl#";
    public static final String PREFIX_XSD = "http://www.w3.org/2001/XMLSchema#";
    public static final String PREFIX_SCHEMA = "http://schema.org/";
    public static final String PREFIX_SKOS = "http://www.w3.org/2004/02/skos/core#";
    public static final String PREFIX_PROV = "http://www.w3.org/ns/prov#";
    public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    public static final String RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    public static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
    public static final String RDFS_SEE_ALSO = "http://www.w3.org/2000/01/rdf-schema#seeAlso";
    public static final String RDFS_LITERAL = "http://www.w3.org/2000/01/rdf-schema#Literal";
    public static final String RDFS_SUBCLASS_OF = "http://www.w3.org/2000/01/rdf-schema#subClassOf";
    public static final String RDFS_SUBPROPERTY_OF = "http://www.w3.org/2000/01/rdf-schema#subPropertyOf";
    public static final String OWL_THING = "http://www.w3.org/2002/07/owl#Thing";
    public static final String OWL_CLASS = "http://www.w3.org/2002/07/owl#Class";
    public static final String OWL_OBJECT_PROPERTY = "http://www.w3.org/2002/07/owl#ObjectProperty";
    public static final String OWL_DATATYPE_PROPERTY = "http://www.w3.org/2002/07/owl#DatatypeProperty";
    public static final String OWL_RESTRICTION = "http://www.w3.org/2002/07/owl#Restriction";
    public static final String OWL_SOME_VALUES_FROM = "http://www.w3.org/2002/07/owl#someValuesFrom";
    public static final String OWL_ON_PROPERTY = "http://www.w3.org/2002/07/owl#onProperty";
    public static final String OWL_COMPLEMENT_OF = "http://www.w3.org/2002/07/owl#complementOf";
    public static final String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    public static final String XSD_DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal";
    public static final String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    public static final String XSD_DATE = "http://www.w3.org/2001/XMLSchema#date";
    public static final String XSD_G_YEAR = "http://www.w3.org/2001/XMLSchema#gYear";
    public static final String XSD_G_YEAR_MONTH = "http://www.w3.org/2001/XMLSchema#gYearMonth";
    public static final String XSD_DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    public static final String OGC_LOCATION = "http://www.opengis.net/ont/geosparql#wktLiteral";
    public static final String DT_ITEM = "http://wikiba.se/ontology#WikibaseItem";
    public static final String DT_PROPERTY = "http://wikiba.se/ontology#WikibaseProperty";
    public static final String DT_LEXEME = "http://wikiba.se/ontology#WikibaseLexeme";
    public static final String DT_FORM = "http://wikiba.se/ontology#WikibaseForm";
    public static final String DT_SENSE = "http://wikiba.se/ontology#WikibaseSense";
    public static final String DT_MEDIA_INFO = "http://wikiba.se/ontology#WikibaseMediaInfo";
    public static final String DT_STRING = "http://wikiba.se/ontology#String";
    public static final String DT_URL = "http://wikiba.se/ontology#Url";
    public static final String DT_COMMONS_MEDIA = "http://wikiba.se/ontology#CommonsMedia";
    public static final String DT_TIME = "http://wikiba.se/ontology#Time";
    public static final String DT_GLOBE_COORDINATES = "http://wikiba.se/ontology#GlobeCoordinate";
    public static final String DT_QUANTITY = "http://wikiba.se/ontology#Quantity";
    public static final String DT_MONOLINGUAL_TEXT = "http://wikiba.se/ontology#Monolingualtext";
    public static final String DT_EXTERNAL_ID = "http://wikiba.se/ontology#ExternalId";
    public static final String DT_MATH = "http://wikiba.se/ontology#Math";
    public static final String DT_GEO_SHAPE = "http://wikiba.se/ontology#GeoShape";
    public static final String DT_TABULAR_DATA = "http://wikiba.se/ontology#TabularData";
    public static final String DT_EDTF = "http://wikiba.se/ontology#Edtf";
    static final Map<String, String> VOCABULARY_TYPES;
    public static final String SKOS_ALT_LABEL = "http://www.w3.org/2004/02/skos/core#altLabel";
    public static final String SCHEMA_ABOUT = "http://schema.org/about";
    public static final String SCHEMA_ARTICLE = "http://schema.org/Article";
    public static final String SCHEMA_DESCRIPTION = "http://schema.org/description";
    public static final String SCHEMA_IN_LANGUAGE = "http://schema.org/inLanguage";
    public static final String PROV_WAS_DERIVED_FROM = "http://www.w3.org/ns/prov#wasDerivedFrom";
    public static final String WB_ITEM = "http://wikiba.se/ontology#Item";
    public static final String WB_REFERENCE = "http://wikiba.se/ontology#Reference";
    public static final String WB_PROPERTY = "http://wikiba.se/ontology#Property";
    public static final String WB_STATEMENT = "http://wikiba.se/ontology#Statement";
    public static final String WB_QUANTITY_VALUE = "http://wikiba.se/ontology#QuantityValue";
    public static final String WB_TIME_VALUE = "http://wikiba.se/ontology#TimeValue";
    public static final String WB_GLOBE_COORDINATES_VALUE = "http://wikiba.se/ontology#GlobecoordinateValue";
    public static final String WB_PROPERTY_TYPE = "http://wikiba.se/ontology#propertyType";
    public static final String WB_RANK = "http://wikiba.se/ontology#rank";
    public static final String WB_BEST_RANK = "http://wikiba.se/ontology#BestRank";
    public static final String WB_GEO_GLOBE = "http://wikiba.se/ontology#geoGlobe";
    public static final String WB_GEO_LATITUDE = "http://wikiba.se/ontology#geoLatitude";
    public static final String WB_GEO_LONGITUDE = "http://wikiba.se/ontology#geoLongitude";
    public static final String WB_GEO_PRECISION = "http://wikiba.se/ontology#geoPrecision";
    public static final String WB_TIME = "http://wikiba.se/ontology#timeValue";
    public static final String WB_TIME_PRECISION = "http://wikiba.se/ontology#timePrecision";
    public static final String WB_TIME_TIMEZONE = "http://wikiba.se/ontology#timeTimezone";
    public static final String WB_TIME_CALENDAR_MODEL = "http://wikiba.se/ontology#timeCalendarModel";
    public static final String WB_QUANTITY_AMOUNT = "http://wikiba.se/ontology#quantityAmount";
    public static final String WB_QUANTITY_LOWER_BOUND = "http://wikiba.se/ontology#quantityLowerBound";
    public static final String WB_QUANTITY_UPPER_BOUND = "http://wikiba.se/ontology#quantityUpperBound";
    public static final String WB_QUANTITY_UNIT = "http://wikiba.se/ontology#quantityUnit";
    public static final String WB_NO_UNIT = "http://www.wikidata.org/entity/Q199";
    public static final String WB_NORMAL_RANK = "http://wikiba.se/ontology#NormalRank";
    public static final String WB_PREFERRED_RANK = "http://wikiba.se/ontology#PreferredRank";
    public static final String WB_DEPRECATED_RANK = "http://wikiba.se/ontology#DeprecatedRank";
    public static final String WB_BADGE = "http://wikiba.se/ontology#badge";
    public static final String WB_DIRECT_CLAIM_PROP = "http://wikiba.se/ontology#directClaim";
    public static final String WB_CLAIM_PROP = "http://wikiba.se/ontology#claim";
    public static final String WB_STATEMENT_PROP = "http://wikiba.se/ontology#statementProperty";
    public static final String WB_STATEMENT_VALUE_PROP = "http://wikiba.se/ontology#statementValue";
    public static final String WB_QUALIFIER_PROP = "http://wikiba.se/ontology#qualifier";
    public static final String WB_QUALIFIER_VALUE_PROP = "http://wikiba.se/ontology#qualifierValue";
    public static final String WB_REFERENCE_PROP = "http://wikiba.se/ontology#reference";
    public static final String WB_REFERENCE_VALUE_PROP = "http://wikiba.se/ontology#referenceValue";
    public static final String WB_NO_VALUE_PROP = "http://wikiba.se/ontology#novalue";
    public static final String WB_NO_QUALIFIER_VALUE_PROP = "http://wikiba.se/ontology#novalue";
    static ByteBuffer longByteBuffer;
    static ByteBuffer intByteBuffer;
    protected static final char[] hexArray;

    public static Map<String, String> getKnownVocabularyTypes() {
        return Collections.unmodifiableMap(VOCABULARY_TYPES);
    }

    public static String getStatementUri(Statement statement) {
        String statementId = statement.getStatementId();
        if (statementId == null || statementId.isEmpty()) {
            statementId = GUID_GENERATOR.freshStatementId(statement.getSubject().getId());
        }
        return PREFIX_WIKIDATA_STATEMENT + statementId.replaceFirst("\\$", "-");
    }

    public static String getPropertyUri(PropertyIdValue propertyIdValue, PropertyContext propertyContext) {
        switch (propertyContext) {
            case DIRECT: {
                return PREFIX_PROPERTY_DIRECT + propertyIdValue.getId();
            }
            case STATEMENT: {
                return PREFIX_PROPERTY + propertyIdValue.getId();
            }
            case VALUE_SIMPLE: {
                return PREFIX_PROPERTY_STATEMENT + propertyIdValue.getId();
            }
            case VALUE: {
                return PREFIX_PROPERTY_STATEMENT_VALUE + propertyIdValue.getId();
            }
            case QUALIFIER: {
                return PREFIX_PROPERTY_QUALIFIER_VALUE + propertyIdValue.getId();
            }
            case QUALIFIER_SIMPLE: {
                return PREFIX_PROPERTY_QUALIFIER + propertyIdValue.getId();
            }
            case REFERENCE: {
                return PREFIX_PROPERTY_REFERENCE_VALUE + propertyIdValue.getId();
            }
            case REFERENCE_SIMPLE: {
                return PREFIX_PROPERTY_REFERENCE + propertyIdValue.getId();
            }
            case NO_VALUE: {
                return "http://www.wikidata.org/prop/novalue/" + propertyIdValue.getId();
            }
            case NO_QUALIFIER_VALUE: {
                return "http://www.wikidata.org/prop/novalue/" + propertyIdValue.getId();
            }
        }
        return null;
    }

    public static String getReferenceUri(Reference reference) {
        String hash = reference.getHash();
        if (hash != null) {
            return PREFIX_WIKIDATA_REFERENCE + hash;
        }
        md.reset();
        reference.getSnakGroups().stream().flatMap(g -> g.getSnaks().stream()).map(Objects::hashCode).sorted().forEach(i -> Vocabulary.updateMessageDigestWithInt(md, i));
        return PREFIX_WIKIDATA_REFERENCE + Vocabulary.bytesToHex(md.digest());
    }

    public static String getTimeValueUri(TimeValue value) {
        md.reset();
        Vocabulary.updateMessageDigestWithLong(md, value.getYear());
        md.update(value.getMonth());
        md.update(value.getDay());
        md.update(value.getHour());
        md.update(value.getMinute());
        md.update(value.getSecond());
        md.update(value.getPrecision());
        Vocabulary.updateMessageDigestWithString(md, value.getPreferredCalendarModel());
        Vocabulary.updateMessageDigestWithInt(md, value.getBeforeTolerance());
        Vocabulary.updateMessageDigestWithInt(md, value.getAfterTolerance());
        Vocabulary.updateMessageDigestWithInt(md, value.getTimezoneOffset());
        return PREFIX_WIKIDATA_VALUE + Vocabulary.bytesToHex(md.digest());
    }

    public static String getGlobeCoordinatesValueUri(GlobeCoordinatesValue value) {
        md.reset();
        Vocabulary.updateMessageDigestWithString(md, value.getGlobe());
        Vocabulary.updateMessageDigestWithLong(md, Double.valueOf(value.getLatitude()).hashCode());
        Vocabulary.updateMessageDigestWithLong(md, Double.valueOf(value.getLongitude()).hashCode());
        Vocabulary.updateMessageDigestWithLong(md, Double.valueOf(value.getPrecision()).hashCode());
        return PREFIX_WIKIDATA_VALUE + Vocabulary.bytesToHex(md.digest());
    }

    public static String getQuantityValueUri(QuantityValue value) {
        md.reset();
        Vocabulary.updateMessageDigestWithInt(md, value.getNumericValue().hashCode());
        if (value.getLowerBound() != null) {
            Vocabulary.updateMessageDigestWithInt(md, value.getLowerBound().hashCode());
        }
        if (value.getUpperBound() != null) {
            Vocabulary.updateMessageDigestWithInt(md, value.getUpperBound().hashCode());
        }
        Vocabulary.updateMessageDigestWithInt(md, value.getUnit().hashCode());
        return PREFIX_WIKIDATA_VALUE + Vocabulary.bytesToHex(md.digest());
    }

    public static String getStatementRankUri(StatementRank rank) {
        switch (rank) {
            case NORMAL: {
                return WB_NORMAL_RANK;
            }
            case PREFERRED: {
                return WB_PREFERRED_RANK;
            }
            case DEPRECATED: {
                return WB_DEPRECATED_RANK;
            }
        }
        throw new IllegalArgumentException();
    }

    static void updateMessageDigestWithLong(MessageDigest md, long x) {
        longByteBuffer.putLong(0, x);
        longByteBuffer.rewind();
        md.update(longByteBuffer);
    }

    static void updateMessageDigestWithInt(MessageDigest md, int x) {
        intByteBuffer.putInt(0, x);
        intByteBuffer.rewind();
        md.update(intByteBuffer);
    }

    static void updateMessageDigestWithString(MessageDigest md, String s) {
        if (s == null) {
            return;
        }
        md.update(s.getBytes(StandardCharsets.UTF_8));
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Your Java does not support MD5 hashes. You should be concerned.");
        }
        GUID_GENERATOR = new RandomGuidGenerator();
        VOCABULARY_TYPES = new HashMap<String, String>();
        VOCABULARY_TYPES.put(SKOS_ALT_LABEL, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(SCHEMA_ABOUT, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(SCHEMA_ARTICLE, OWL_CLASS);
        VOCABULARY_TYPES.put(SCHEMA_DESCRIPTION, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(SCHEMA_IN_LANGUAGE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(PROV_WAS_DERIVED_FROM, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_ITEM, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_REFERENCE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_PROPERTY, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_STATEMENT, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_QUANTITY_VALUE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_TIME_VALUE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_GLOBE_COORDINATES_VALUE, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_PROPERTY_TYPE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_RANK, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_BEST_RANK, OWL_CLASS);
        VOCABULARY_TYPES.put(WB_GEO_GLOBE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_GEO_LATITUDE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_GEO_LONGITUDE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_GEO_PRECISION, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_TIME, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_TIME_PRECISION, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_TIME_TIMEZONE, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_TIME_CALENDAR_MODEL, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUANTITY_AMOUNT, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUANTITY_LOWER_BOUND, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUANTITY_UPPER_BOUND, OWL_DATATYPE_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUANTITY_UNIT, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_BADGE, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_DIRECT_CLAIM_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_CLAIM_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_STATEMENT_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_STATEMENT_VALUE_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUALIFIER_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_QUALIFIER_VALUE_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_REFERENCE_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put(WB_REFERENCE_VALUE_PROP, OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put("http://wikiba.se/ontology#novalue", OWL_OBJECT_PROPERTY);
        VOCABULARY_TYPES.put("http://wikiba.se/ontology#novalue", OWL_OBJECT_PROPERTY);
        longByteBuffer = ByteBuffer.allocate(8);
        intByteBuffer = ByteBuffer.allocate(4);
        hexArray = "0123456789abcdef".toCharArray();
    }
}

