/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.values.AbstractValueConverter;

public abstract class BufferedValueConverter<V extends Value>
extends AbstractValueConverter<V> {
    final List<V> valueQueue = new ArrayList<V>();
    final List<Resource> valueSubjectQueue = new ArrayList<Resource>();
    final HashSet<Resource> declaredValues = new HashSet();

    public BufferedValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    void addValue(V value, Resource resource) {
        this.valueQueue.add(value);
        this.valueSubjectQueue.add(resource);
    }

    @Override
    public void writeAuxiliaryTriples() throws RDFHandlerException {
        Iterator<V> valueIterator = this.valueQueue.iterator();
        for (Resource resource : this.valueSubjectQueue) {
            if (!this.declaredValues.add(resource)) {
                valueIterator.next();
                continue;
            }
            this.writeValue((Value)valueIterator.next(), resource);
        }
        this.valueSubjectQueue.clear();
        this.valueQueue.clear();
    }

    public abstract void writeValue(V var1, Resource var2) throws RDFHandlerException;
}

