/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.eclipse.rdf4j.model.Value;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.values.AbstractValueConverter;

public class EntityIdValueConverter
extends AbstractValueConverter<EntityIdValue> {
    public EntityIdValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(EntityIdValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype = this.propertyRegister.setPropertyTypeFromEntityIdValue(propertyIdValue, value);
        if (datatype == null) {
            return this.rdfWriter.getFreshBNode();
        }
        switch (datatype) {
            case "http://wikiba.se/ontology#WikibaseItem": 
            case "http://wikiba.se/ontology#WikibaseProperty": 
            case "http://wikiba.se/ontology#WikibaseLexeme": 
            case "http://wikiba.se/ontology#WikibaseForm": 
            case "http://wikiba.se/ontology#WikibaseSense": {
                if (simple) {
                    this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                    return this.rdfWriter.getUri(value.getIri());
                }
                return null;
            }
        }
        this.logIncompatibleValueError(propertyIdValue, datatype, "entity");
        return this.rdfWriter.getFreshBNode();
    }
}

