/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.BufferedValueConverter;

public class GlobeCoordinatesValueConverter
extends BufferedValueConverter<GlobeCoordinatesValue> {
    public GlobeCoordinatesValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(GlobeCoordinatesValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype;
        switch (datatype = this.propertyRegister.setPropertyTypeFromGlobeCoordinatesValue(propertyIdValue, value)) {
            case "http://wikiba.se/ontology#GlobeCoordinate": {
                if (simple) {
                    return this.getSimpleGeoValue(value);
                }
                IRI valueUri = this.rdfWriter.getUri(Vocabulary.getGlobeCoordinatesValueUri(value));
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                this.addValue(value, (Resource)valueUri);
                return valueUri;
            }
        }
        this.logIncompatibleValueError(propertyIdValue, datatype, "globe coordinates");
        return null;
    }

    @Override
    public void writeValue(GlobeCoordinatesValue value, Resource resource) throws RDFHandlerException {
        IRI globeUri;
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_GLOBE_COORDINATES_VALUE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_GEO_LATITUDE, Double.valueOf(value.getLatitude()).toString(), RdfWriter.XSD_DOUBLE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_GEO_LONGITUDE, Double.valueOf(value.getLongitude()).toString(), RdfWriter.XSD_DOUBLE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_GEO_PRECISION, Double.valueOf(value.getPrecision()).toString(), RdfWriter.XSD_DOUBLE);
        try {
            globeUri = this.rdfWriter.getUri(value.getGlobe());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid globe URI \"" + value.getGlobe() + "\". Assuming Earth (http://www.wikidata.org/entity/Q2).");
            globeUri = this.rdfWriter.getUri("http://www.wikidata.org/entity/Q2");
        }
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.WB_GEO_GLOBE, (Value)globeUri);
    }

    private Literal getSimpleGeoValue(GlobeCoordinatesValue value) {
        StringBuilder builder = new StringBuilder();
        if (!value.getGlobe().equals("http://www.wikidata.org/entity/Q2")) {
            builder.append("<").append(value.getGlobe().replace(">", "%3E")).append("> ");
        }
        builder.append("Point(");
        builder.append(value.getLongitude());
        builder.append(" ");
        builder.append(value.getLatitude());
        builder.append(")");
        return this.rdfWriter.getLiteral(builder.toString(), RdfWriter.OGC_LOCATION);
    }
}

