/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.rdf4j.model.Value;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.values.AbstractValueConverter;

public class StringValueConverter
extends AbstractValueConverter<StringValue> {
    public StringValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(StringValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype = this.propertyRegister.setPropertyTypeFromStringValue(propertyIdValue, value);
        String valueUriString = null;
        switch (datatype) {
            case "http://wikiba.se/ontology#String": 
            case "http://wikiba.se/ontology#ExternalId": 
            case "http://wikiba.se/ontology#Math": {
                valueUriString = null;
                break;
            }
            case "http://wikiba.se/ontology#CommonsMedia": {
                if (!simple) break;
                valueUriString = StringValueConverter.getCommonsFileUrl(value.getString());
                break;
            }
            case "http://wikiba.se/ontology#Url": {
                if (!simple) break;
                valueUriString = value.getString();
                break;
            }
            case "http://wikiba.se/ontology#GeoShape": 
            case "http://wikiba.se/ontology#TabularData": {
                if (!simple) break;
                valueUriString = StringValueConverter.getCommonsDataUrl(value.getString());
                break;
            }
            default: {
                this.logIncompatibleValueError(propertyIdValue, datatype, "string");
                return null;
            }
        }
        if (valueUriString == null) {
            if (simple) {
                this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                return this.rdfWriter.getLiteral(value.getString());
            }
            return null;
        }
        this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
        try {
            return this.rdfWriter.getUri(valueUriString);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid URI \"" + valueUriString + "\". Not serializing value.");
            return null;
        }
    }

    static String getCommonsFileUrl(String pageName) {
        try {
            return "http://commons.wikimedia.org/wiki/File:" + URLEncoder.encode(pageName.replace(' ', '_'), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static String getCommonsDataUrl(String pageName) {
        try {
            return "http://commons.wikimedia.org/data/main/" + URLEncoder.encode(pageName.replace(' ', '_'), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

