/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import java.time.Month;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.BufferedValueConverter;

public class TimeValueConverter
extends BufferedValueConverter<TimeValue> {
    public TimeValueConverter(RdfWriter rdfWriter, PropertyRegister PropertyRegister2, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, PropertyRegister2, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(TimeValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype;
        switch (datatype = this.propertyRegister.setPropertyTypeFromTimeValue(propertyIdValue, value)) {
            case "http://wikiba.se/ontology#Time": {
                if (simple) {
                    this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                    return TimeValueConverter.getTimeLiteral(value, this.rdfWriter);
                }
                IRI valueUri = this.rdfWriter.getUri(Vocabulary.getTimeValueUri(value));
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                this.addValue(value, (Resource)valueUri);
                return valueUri;
            }
        }
        this.logIncompatibleValueError(propertyIdValue, datatype, "time");
        return null;
    }

    @Override
    public void writeValue(TimeValue value, Resource resource) throws RDFHandlerException {
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_TIME_VALUE);
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.WB_TIME, (Value)TimeValueConverter.getTimeLiteral(value, this.rdfWriter));
        this.rdfWriter.writeTripleIntegerObject(resource, RdfWriter.WB_TIME_PRECISION, value.getPrecision());
        this.rdfWriter.writeTripleIntegerObject(resource, RdfWriter.WB_TIME_TIMEZONE, value.getTimezoneOffset());
        this.rdfWriter.writeTripleUriObject(resource, RdfWriter.WB_TIME_CALENDAR_MODEL, value.getPreferredCalendarModel());
    }

    private static Literal getTimeLiteral(TimeValue value, RdfWriter rdfWriter) {
        byte by;
        int n;
        long year;
        boolean yearZero = value.getYear() == 0L;
        TimeValue gregorian = value.toGregorian();
        if (gregorian != null) {
            value = gregorian;
        }
        if ((year = value.getYear()) < 0L && value.getPrecision() >= 9) {
            ++year;
        }
        byte month = value.getMonth();
        byte by2 = value.getDay();
        if (!(value.getPrecision() >= 10 && month != 0 || yearZero)) {
            month = 1;
        }
        if (!(value.getPrecision() >= 11 && by2 != 0 || yearZero)) {
            n = 1;
        }
        if (value.getPrecision() >= 11 && !yearZero) {
            int maxDays = 127;
            if (month > 0 && month < 13) {
                boolean leap = year % 4L == 0L && (year % 100L != 0L || year % 400L == 0L);
                maxDays = Month.of(month).length(leap);
            }
            if (n > maxDays) {
                by = (byte)maxDays;
            }
        }
        String minus = year < 0L ? "-" : "";
        String timestamp = String.format("%s%04d-%02d-%02dT%02d:%02d:%02dZ", minus, Math.abs(year), month, by, value.getHour(), value.getMinute(), value.getSecond());
        if (yearZero) {
            return rdfWriter.getLiteral("+" + timestamp);
        }
        return rdfWriter.getLiteral(timestamp, RdfWriter.XSD_DATETIME);
    }
}

