/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.datastructures;

import java.util.Iterator;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.storage.datastructures.BitVector;
import org.wikidata.wdtk.storage.datastructures.BitVectorIterator;

public class BitVectorImpl
implements BitVector,
Iterable<Boolean> {
    static final int GROWTH_FACTOR = 2;
    static final int LG_WORD_SIZE = 6;
    static final int MINIMUM_ARRAY_SIZE = 1;
    static final int WORD_MASK = 63;
    static final int WORD_SIZE = 64;
    long[] arrayOfBits;
    int hashCode;
    long size;
    boolean validHashCode = false;

    public BitVectorImpl() {
        this.arrayOfBits = new long[1];
    }

    public BitVectorImpl(BitVector bitVector) {
        Validate.notNull((Object)bitVector, (String)"Bit vector cannot be null.", (Object[])new Object[0]);
        if (bitVector instanceof BitVectorImpl) {
            BitVectorImpl other = (BitVectorImpl)bitVector;
            this.arrayOfBits = new long[other.arrayOfBits.length];
            this.size = bitVector.size();
            System.arraycopy(other.arrayOfBits, 0, this.arrayOfBits, 0, other.arrayOfBits.length);
        } else {
            this.arrayOfBits = new long[BitVectorImpl.getMinimumArraySize(bitVector.size())];
            this.size = bitVector.size();
            long index = 0L;
            while (index < bitVector.size()) {
                this.setBit(index, bitVector.getBit(index));
                ++index;
            }
        }
    }

    public BitVectorImpl(long initialSize) {
        if (initialSize < 0L) {
            throw new IllegalArgumentException("Wrong bit vector size '" + initialSize + "'. Bit vector size must be non-negative.");
        }
        this.arrayOfBits = new long[BitVectorImpl.getMinimumArraySize(initialSize)];
        this.size = initialSize;
    }

    static boolean getBitInWord(byte position, long word) {
        if (position < 0 || position >= 64) {
            throw new IndexOutOfBoundsException();
        }
        return (word >> position & 1L) == 1L;
    }

    static int getMinimumArraySize(long bitVectorSize) {
        return Math.max(1, BitVectorImpl.getSizeInWords(bitVectorSize));
    }

    static long setBitInWord(byte position, boolean bit, long word) {
        if (BitVectorImpl.getBitInWord(position, word) == bit) {
            return word;
        }
        return word ^ 1L << position;
    }

    static String wordToString(long word) {
        String binaryDigits = String.format("%64s", Long.toBinaryString(word)).replace(' ', '0');
        return new StringBuilder(binaryDigits).reverse().toString();
    }

    static int getSizeInWords(long sizeInBits) {
        return (int)((sizeInBits >> 6) + 1L);
    }

    @Override
    public boolean addBit(boolean bit) {
        this.validHashCode = false;
        ++this.size;
        if (BitVectorImpl.getSizeInWords(this.size) > this.arrayOfBits.length) {
            this.resizeArray(2 * this.arrayOfBits.length);
        }
        this.setBit(this.size - 1L, bit);
        return true;
    }

    void assertNonNegativePosition(long position) throws IndexOutOfBoundsException {
        if (position < 0L) {
            throw new IndexOutOfBoundsException("Position " + position + " is out of bounds.");
        }
    }

    void ensureSize(long position) {
        this.assertNonNegativePosition(position);
        if (position >= this.size) {
            this.validHashCode = false;
            long newSize = position + 1L;
            int arrayOfBitsLength = this.arrayOfBits.length;
            int sizeInWords = BitVectorImpl.getSizeInWords(newSize);
            while (sizeInWords > arrayOfBitsLength) {
                arrayOfBitsLength *= 2;
            }
            this.resizeArray(arrayOfBitsLength);
            this.size = newSize;
        }
    }

    int computeHashCode() {
        int ret = (int)this.size;
        int arraySize = (int)(this.size >> 6);
        int i = 0;
        while (i < arraySize) {
            ret = (int)((long)ret + 31L * this.arrayOfBits[i]);
            ++i;
        }
        long lastWordStart = arraySize << 6;
        long remainingBits = this.size - lastWordStart;
        long lastWord = 0L;
        int i2 = 0;
        while ((long)i2 < remainingBits) {
            lastWord = BitVectorImpl.setBitInWord((byte)i2, this.getBit((long)i2 + lastWordStart), lastWord);
            ++i2;
        }
        ret = (int)((long)ret + 31L * lastWord);
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitVector)) {
            return false;
        }
        BitVector other = (BitVector)obj;
        if (this.size != other.size()) {
            return false;
        }
        long comparisonFirstPos = 0L;
        if (other instanceof BitVectorImpl) {
            BitVectorImpl otherBitVectorImpl = (BitVectorImpl)other;
            int arraySize = (int)(this.size >> 6);
            int i = 0;
            while (i < arraySize) {
                if (this.arrayOfBits[i] != otherBitVectorImpl.arrayOfBits[i]) {
                    return false;
                }
                ++i;
            }
            comparisonFirstPos = (long)arraySize << 6;
        }
        long i = comparisonFirstPos;
        while (i < this.size) {
            if (this.getBit(i) != other.getBit(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean getBit(long position) {
        this.assertNonNegativePosition(position);
        if (position >= this.size) {
            return false;
        }
        int arrayPos = (int)(position >> 6);
        byte wordPos = (byte)(position & 0x3FL);
        return BitVectorImpl.getBitInWord(wordPos, this.arrayOfBits[arrayPos]);
    }

    public int hashCode() {
        if (!this.validHashCode) {
            this.hashCode = this.computeHashCode();
            this.validHashCode = true;
        }
        return this.hashCode;
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new BitVectorIterator(this);
    }

    void resizeArray(int newArraySize) {
        long[] newArray = new long[newArraySize];
        System.arraycopy(this.arrayOfBits, 0, newArray, 0, Math.min(this.arrayOfBits.length, newArraySize));
        this.arrayOfBits = newArray;
    }

    @Override
    public void setBit(long position, boolean bit) {
        this.ensureSize(position);
        this.validHashCode = false;
        int arrayPos = (int)(position >> 6);
        byte wordPos = (byte)(position & 0x3FL);
        this.arrayOfBits[arrayPos] = BitVectorImpl.setBitInWord(wordPos, bit, this.arrayOfBits[arrayPos]);
    }

    @Override
    public long size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long position = 0L;
        while (position < this.size) {
            sb.append(this.getBit(position) ? "1" : "0");
            ++position;
        }
        return sb.toString();
    }
}

