/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.testing;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.wikidata.wdtk.testing.MockOutputStream;
import org.wikidata.wdtk.testing.MockStringContentFactory;
import org.wikidata.wdtk.util.CompressionType;
import org.wikidata.wdtk.util.DirectoryManager;

public class MockDirectoryManager
implements DirectoryManager {
    static final String DIRECTORY_MARKER_STRING = "DIRECTORY";
    static final byte[] DIRECTORY_MARKER = "DIRECTORY".getBytes(StandardCharsets.UTF_8);
    public static HashMap<Path, byte[]> files = new HashMap();
    final Path directory;
    boolean returnFailingReaders;
    final boolean readOnly;

    public MockDirectoryManager(Path directory, Boolean readOnly) throws IOException {
        this(directory, false, readOnly);
    }

    public MockDirectoryManager(String baseDirectory, Boolean readOnly) throws IOException {
        this(Paths.get(baseDirectory, new String[0]), readOnly);
    }

    public MockDirectoryManager(Path directory, boolean resetFileSystem, boolean readOnly) throws IOException {
        this.directory = directory;
        this.readOnly = readOnly;
        if (resetFileSystem) {
            files = new HashMap();
            this.setDirectory(directory);
        }
        if (files.containsKey(directory)) {
            if (!Arrays.equals(files.get(directory), DIRECTORY_MARKER)) {
                throw new IOException("Could not create mock working directory.");
            }
        } else {
            this.ensureWritePermission(directory);
            this.setDirectory(directory);
        }
    }

    public void setReturnFailingReaders(boolean returnFailingReaders) {
        this.returnFailingReaders = returnFailingReaders;
    }

    public String toString() {
        return "[mocked directory] " + this.directory.toString();
    }

    public void setFileContents(Path path, String contents) throws IOException {
        this.setFileContents(path, contents, CompressionType.NONE);
    }

    public void setFileContents(Path path, String contents, CompressionType compressionType) throws IOException {
        files.put(path, MockStringContentFactory.getBytesFromString(contents, compressionType));
        Path parent = path.getParent();
        if (parent != null) {
            this.setFileContents(parent, DIRECTORY_MARKER_STRING);
        }
    }

    public void setDirectory(Path path) throws IOException {
        this.setFileContents(path, DIRECTORY_MARKER_STRING);
    }

    public DirectoryManager getSubdirectoryManager(String subdirectoryName) throws IOException {
        MockDirectoryManager result = new MockDirectoryManager(this.directory.resolve(subdirectoryName), false, this.readOnly);
        result.setReturnFailingReaders(this.returnFailingReaders);
        return result;
    }

    public boolean hasSubdirectory(String subdirectoryName) {
        Path directoryPath = this.directory.resolve(subdirectoryName);
        return Arrays.equals(DIRECTORY_MARKER, files.get(directoryPath));
    }

    public boolean hasFile(String fileName) {
        Path filePath = this.directory.resolve(fileName);
        return files.containsKey(filePath) && !Arrays.equals(files.get(filePath), DIRECTORY_MARKER);
    }

    public long createFile(String fileName, InputStream inputStream) throws IOException {
        int nextByte;
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((nextByte = inputStream.read()) >= 0) {
            out.write(nextByte);
        }
        out.close();
        files.put(filePath, out.toByteArray());
        return out.size();
    }

    public long createFileAtomic(String fileName, InputStream inputStream) throws IOException {
        return this.createFile(fileName, inputStream);
    }

    public void createFile(String fileName, String fileContents) throws IOException {
        if (this.hasFile(fileName)) {
            throw new FileAlreadyExistsException("File exists");
        }
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        files.put(filePath, fileContents.getBytes(StandardCharsets.UTF_8));
    }

    public OutputStream getOutputStreamForFile(String fileName) throws IOException {
        Path filePath = this.directory.resolve(fileName);
        this.ensureWritePermission(filePath);
        return new MockOutputStream(filePath);
    }

    public InputStream getInputStreamForFile(String fileName, CompressionType compressionType) throws IOException {
        if (compressionType == CompressionType.GZIP) {
            return new GZIPInputStream(this.getInputStreamForMockFile(fileName));
        }
        if (compressionType == CompressionType.BZ2) {
            return new BZip2CompressorInputStream(this.getInputStreamForMockFile(fileName));
        }
        return this.getInputStreamForMockFile(fileName);
    }

    InputStream getInputStreamForMockFile(String fileName) throws FileNotFoundException {
        if (!this.hasFile(fileName)) {
            throw new FileNotFoundException("Could not find file \"" + fileName + "\" in current directory \"" + this.directory.toString() + "\"");
        }
        if (this.returnFailingReaders) {
            return MockStringContentFactory.getFailingInputStream();
        }
        Path filePath = this.directory.resolve(fileName);
        return MockStringContentFactory.newMockInputStream(files.get(filePath));
    }

    public List<String> getSubdirectories(String glob) {
        ArrayList<String> result = new ArrayList<String>();
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        for (Path path : files.keySet()) {
            if (!this.directory.equals(path.getParent()) || !pathMatcher.matches(path.getFileName())) continue;
            result.add(path.getFileName().toString());
        }
        return result;
    }

    public static byte[] getMockedFileContents(Path filePath) {
        return files.get(filePath);
    }

    void ensureWritePermission(Path writeFilePath) throws IOException {
        if (this.readOnly) {
            throw new IOException("Cannot write to \"" + writeFilePath.toString() + "\" since we are in read-only mode.");
        }
    }
}

