/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.testing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.mockito.Mockito;
import org.wikidata.wdtk.util.CompressionType;

public class MockStringContentFactory {
    public static InputStream newMockInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream newMockInputStream(byte[] contents) {
        return new ByteArrayInputStream(contents);
    }

    public static String getStringFromUrl(URL url) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        return MockStringContentFactory.getStringFromBufferedReader(br);
    }

    public static String getStringFromBufferedReader(BufferedReader bufferedReader) throws IOException {
        String line;
        StringBuilder contentsBuilder = new StringBuilder();
        boolean firstLine = true;
        while ((line = bufferedReader.readLine()) != null) {
            if (firstLine) {
                firstLine = false;
            } else {
                contentsBuilder.append("\n");
            }
            contentsBuilder.append(line);
        }
        return contentsBuilder.toString();
    }

    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String result = MockStringContentFactory.getStringFromBufferedReader(bufferedReader);
        bufferedReader.close();
        return result;
    }

    public static InputStream getFailingInputStream() {
        InputStream is = (InputStream)Mockito.mock(InputStream.class);
        try {
            ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)is)).read();
            ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)is)).read((byte[])Mockito.any());
            ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)is)).read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt());
        }
        catch (IOException e) {
            throw new RuntimeException("Mockito should not throw anything here. Strange.", e);
        }
        return is;
    }

    public static byte[] getBytesFromString(String string, CompressionType compressionType) throws IOException {
        switch (compressionType) {
            case NONE: {
                return string.getBytes(StandardCharsets.UTF_8);
            }
            case BZ2: 
            case GZIP: {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStreamWriter ow = compressionType == CompressionType.GZIP ? new OutputStreamWriter((OutputStream)new GzipCompressorOutputStream((OutputStream)out), StandardCharsets.UTF_8) : new OutputStreamWriter((OutputStream)new BZip2CompressorOutputStream((OutputStream)out), StandardCharsets.UTF_8);
                ow.write(string);
                ow.close();
                return out.toByteArray();
            }
        }
        throw new RuntimeException("Unknown compression type " + String.valueOf(compressionType));
    }
}

